/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.common.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public abstract class DialogBase
extends JDialog {
    private static final long serialVersionUID = 1L;

    public DialogBase(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.createComponent();
        this.setCenterTo(frame);
    }

    protected abstract void createComponent();

    public void setCenterTo(Component component) {
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        Dimension dimension2 = this.getSize();
        this.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
    }

    protected boolean hasValue(JTextField jTextField) {
        return jTextField.getText().trim().length() > 0;
    }

    protected int getAsInt(JTextField jTextField, int n) {
        try {
            return Integer.parseInt(jTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    protected float getAsFloat(JTextField jTextField, float f) {
        try {
            return Float.parseFloat(jTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    protected boolean isFloat(JTextField jTextField) {
        try {
            Float.parseFloat(jTextField.getText().trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        return jPanel;
    }

    protected JLabel createLabel(String string, Font font) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        jLabel.setMaximumSize(jLabel.getPreferredSize());
        return jLabel;
    }

    protected JTextField createTextField(Font font, DocumentListener documentListener) {
        return this.createTextField(font, documentListener, 0);
    }

    protected JTextField createTextField(Font font, DocumentListener documentListener, int n) {
        JTextField jTextField = new JTextField();
        jTextField.setFont(font);
        int n2 = jTextField.getPreferredSize().height;
        if (n > 0) {
            jTextField.setPreferredSize(new Dimension(n, n2));
            jTextField.setMaximumSize(new Dimension(n, n2));
        } else {
            jTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, n2));
        }
        if (documentListener != null) {
            jTextField.getDocument().addDocumentListener(documentListener);
        }
        return jTextField;
    }

    protected JButton createButton(String string, Font font, ActionListener actionListener) {
        return this.createButton(string, font, actionListener, null);
    }

    protected JButton createButton(String string, Font font, ActionListener actionListener, Dimension dimension) {
        JButton jButton = new JButton(string);
        jButton.setFont(font);
        if (dimension != null) {
            jButton.setMaximumSize(dimension);
        } else {
            jButton.setMaximumSize(jButton.getPreferredSize());
        }
        jButton.addActionListener(actionListener);
        return jButton;
    }
}

