/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public abstract class DataFileReader {
    protected BufferedReader openReader(File file) throws IOException {
        InputStream inputStream = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    protected void closeReader(BufferedReader bufferedReader) {
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected String getQuotedValue(String string, String string2) {
        String[] stringArray = string.split("\"");
        return stringArray.length > 1 ? stringArray[1] : string2;
    }

    protected int toInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }
}

