/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import jp.riken.common.exception.CustomException;
import jp.riken.plot2d.data.DataFileReader;
import jp.riken.plot2d.data.PlotDataPca;

public class DataFileReaderPca
extends DataFileReader {
    private int NCOLUMN_PCA_LINE = 7;
    private int NDATA_PCA = 3;
    private int NCOLUMN_START_PCA = 4;
    private int NROW_START_PCA_LINE = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotDataPca read(File file, float f, float f2) throws CustomException {
        PlotDataPca plotDataPca;
        int n = 0;
        BufferedReader bufferedReader = this.openReader(file);
        try {
            n = this.countColumns(bufferedReader);
        }
        finally {
            this.closeReader(bufferedReader);
        }
        if (n != this.NCOLUMN_PCA_LINE) {
            throw new CustomException("Invalid file format.");
        }
        bufferedReader = this.openReader(file);
        try {
            PlotDataPca plotDataPca2 = this.parse(bufferedReader, n, f, f2);
            if (plotDataPca2.getNumT() == 0) {
                throw new CustomException("no data in file.");
            }
            plotDataPca2.makeXpmData();
            plotDataPca = plotDataPca2;
        }
        catch (Throwable throwable) {
            try {
                this.closeReader(bufferedReader);
                throw throwable;
            }
            catch (IOException iOException) {
                throw new CustomException(iOException);
            }
        }
        this.closeReader(bufferedReader);
        return plotDataPca;
    }

    private int countColumns(BufferedReader bufferedReader) throws IOException {
        int n = 0;
        String string = null;
        int n2 = 1;
        while ((string = bufferedReader.readLine()) != null) {
            if (n2 == this.NROW_START_PCA_LINE) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                n = stringTokenizer.countTokens();
                break;
            }
            ++n2;
        }
        return n;
    }

    private PlotDataPca parse(BufferedReader bufferedReader, int n, float f, float f2) throws IOException {
        PlotDataPca plotDataPca = new PlotDataPca();
        int n2 = -999;
        int n3 = 1;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (n3 == this.NROW_START_PCA_LINE - 1) {
                if (stringTokenizer.countTokens() != 1) {
                    throw new CustomException("Invalid file format.");
                }
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                plotDataPca.setup(n2);
            }
            if (n3 >= this.NROW_START_PCA_LINE) {
                if (stringTokenizer.countTokens() != 7) {
                    throw new CustomException("Invalid file format.");
                }
                float[] fArray = new float[this.NDATA_PCA];
                float f3 = 0.0f;
                try {
                    int n4 = 0;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringTokenizer.nextToken();
                        if (i == this.NCOLUMN_START_PCA - 1) {
                            f3 = f + f2 * (float)(Integer.parseInt(string2) - 1);
                            continue;
                        }
                        if (i < this.NCOLUMN_START_PCA) continue;
                        fArray[n4] = Float.parseFloat(string2);
                        ++n4;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CustomException("Invalid file format.");
                }
                plotDataPca.setPcaValue(n3 - 3, f3, fArray);
            }
            if (++n3 != n2 + 3) continue;
            break;
        }
        return plotDataPca;
    }
}

