/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import jp.riken.common.exception.CustomException;
import jp.riken.plot2d.data.DataFileReader;
import jp.riken.plot2d.data.PlotDataXpm;
import jp.riken.plot2d.data.PointValue;

public class DataFileReaderXpm
extends DataFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotDataXpm read(File file) throws CustomException {
        PlotDataXpm plotDataXpm;
        BufferedReader bufferedReader = this.openReader(file);
        try {
            PlotDataXpm plotDataXpm2 = this.parse(bufferedReader);
            if (plotDataXpm2.getNumX() == 0) {
                throw new CustomException("Invalid file format.");
            }
            plotDataXpm2.createLabelGrid();
            plotDataXpm2.parseLabelX();
            plotDataXpm = plotDataXpm2;
        }
        catch (Throwable throwable) {
            try {
                this.closeReader(bufferedReader);
                throw throwable;
            }
            catch (IOException iOException) {
                throw new CustomException(iOException);
            }
        }
        this.closeReader(bufferedReader);
        return plotDataXpm;
    }

    private PlotDataXpm parse(BufferedReader bufferedReader) throws IOException {
        PlotDataXpm plotDataXpm = new PlotDataXpm();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!bl && string.startsWith("/*")) {
                stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                if ("title:".equals(object)) {
                    plotDataXpm.setTitle(this.getQuotedValue(string, ""));
                    continue;
                }
                if ("subtitle:".equals(object)) {
                    plotDataXpm.setSubtitle(this.getQuotedValue(string, ""));
                    continue;
                }
                if ("legend:".equals(object)) {
                    plotDataXpm.setLegend(this.getQuotedValue(string, ""));
                    continue;
                }
                if ("x-label:".equals(object)) {
                    plotDataXpm.setLabelX(this.getQuotedValue(string, ""));
                    continue;
                }
                if (!"y-label:".equals(object)) continue;
                plotDataXpm.setLabelY(this.getQuotedValue(string, ""));
                continue;
            }
            if (!bl && string.startsWith("\"")) {
                object = string.split("\"");
                if (((String[])object).length <= 1) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(object[1]);
                try {
                    n = Integer.parseInt(stringTokenizer2.nextToken());
                    n2 = Integer.parseInt(stringTokenizer2.nextToken());
                    if (n <= 0 || n2 <= 0) {
                        throw new CustomException("Invalid file format.");
                    }
                    plotDataXpm.setup(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CustomException("Invalid file format.");
                }
                bl = true;
                continue;
            }
            if (bl && !bl2 && string.startsWith("\"")) {
                object = string.split("\"");
                if (((String[])object).length <= 1) continue;
                char c = object[1].charAt(0);
                String string2 = object[1].substring(6, 12);
                Color color = new Color(Integer.parseInt(string2, 16));
                String string3 = object[3];
                plotDataXpm.addPointValue(new PointValue(c, color, string3));
                continue;
            }
            if (bl && string.startsWith("/*")) {
                stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                try {
                    String string4;
                    if ("x-axis:".equals(object)) {
                        String string5;
                        while (n3 < n && !(string5 = stringTokenizer.nextToken()).equals("*/")) {
                            plotDataXpm.setXaxis(n3, Integer.parseInt(string5));
                            ++n3;
                        }
                        continue;
                    }
                    if (!"y-axis:".equals(object)) continue;
                    while (n4 < n2 && !(string4 = stringTokenizer.nextToken()).equals("*/")) {
                        plotDataXpm.setYaxis(n4, Integer.parseInt(string4));
                        ++n4;
                    }
                    bl2 = true;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CustomException("Invalid file format.");
                }
            }
            if (!bl || !bl2 || !string.startsWith("\"") || ((String[])(object = string.split("\""))).length <= 1) continue;
            if (object[1].length() != n) {
                throw new CustomException("Invalid file format.");
            }
            for (int i = 0; i < n; ++i) {
                plotDataXpm.setValue(i, n2 - n5 - 1, object[1].charAt(i));
            }
            ++n5;
        }
        return plotDataXpm;
    }
}

