/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import jp.riken.common.exception.CustomException;
import jp.riken.plot2d.data.DataFileReader;
import jp.riken.plot2d.data.PlotDataXvg;

public class DataFileReaderXvg
extends DataFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotDataXvg read(File file) throws CustomException {
        PlotDataXvg plotDataXvg;
        int n = 0;
        BufferedReader bufferedReader = this.openReader(file);
        try {
            n = this.countColumns(bufferedReader);
        }
        finally {
            this.closeReader(bufferedReader);
        }
        if (n < 2) {
            throw new CustomException("Invalid file format.");
        }
        bufferedReader = this.openReader(file);
        try {
            PlotDataXvg plotDataXvg2 = this.parse(bufferedReader, n);
            if (plotDataXvg2.getNumX() == 0) {
                throw new CustomException("Invalid file format.");
            }
            plotDataXvg2.createLabelGrid();
            plotDataXvg2.parseLabelX();
            plotDataXvg = plotDataXvg2;
        }
        catch (Throwable throwable) {
            try {
                this.closeReader(bufferedReader);
                throw throwable;
            }
            catch (IOException iOException) {
                throw new CustomException(iOException);
            }
        }
        this.closeReader(bufferedReader);
        return plotDataXvg;
    }

    private int countColumns(BufferedReader bufferedReader) throws IOException {
        int n = 0;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#") || string.startsWith("@")) continue;
            if (string.startsWith("/") || string.startsWith("\"")) {
                throw new CustomException("Invalid file format.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = stringTokenizer.countTokens();
            break;
        }
        return n;
    }

    private PlotDataXvg parse(BufferedReader bufferedReader, int n) throws IOException {
        int n2 = n - 1;
        PlotDataXvg plotDataXvg = new PlotDataXvg();
        plotDataXvg.setup(n2);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            if (string.startsWith("#")) continue;
            if (string.startsWith("/") || string.startsWith("\"")) {
                throw new CustomException("Invalid file format.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (string.startsWith("@")) {
                int n3;
                stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                if ("title".equals(object)) {
                    plotDataXvg.setTitle(this.getQuotedValue(string, ""));
                    continue;
                }
                if ("subtitle".equals(object)) {
                    plotDataXvg.setSubtitle(this.getQuotedValue(string, ""));
                    continue;
                }
                if ("xaxis".equals(object)) {
                    String string2 = stringTokenizer.nextToken();
                    if (!"label".equals(string2)) continue;
                    plotDataXvg.setLabelX(this.getQuotedValue(string, ""));
                    continue;
                }
                if ("yaxis".equals(object)) {
                    String string3 = stringTokenizer.nextToken();
                    if (!"label".equals(string3)) continue;
                    plotDataXvg.setLabelY(this.getQuotedValue(string, ""));
                    continue;
                }
                if (!((String)object).startsWith("s") || (n3 = this.toInt(((String)object).substring(1), -1)) < 0 || n3 >= n2) continue;
                plotDataXvg.setLegend(n3, this.getQuotedValue(string, ""));
                continue;
            }
            if (stringTokenizer.countTokens() != n) {
                throw new CustomException("Invalid file format.");
            }
            object = new float[n];
            try {
                for (int i = 0; i < n; ++i) {
                    object[i] = Float.parseFloat(stringTokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new CustomException("Invalid file format.");
            }
            plotDataXvg.addPoints((float[])object);
        }
        return plotDataXvg;
    }
}

