/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import jp.riken.plot2d.data.Grid;

public abstract class PlotData {
    protected String title = "";
    protected String subtitle = "";
    protected String labelX = "";
    protected String labelY = "";
    protected Grid labelGrid;
    protected int numX;
    protected int numY;
    protected Float pickValueX;
    protected Integer pickIndexX;
    protected boolean timeAware;
    protected boolean xaxisTime;
    protected boolean pickAware;
    protected float xaxisScale;

    public PlotData() {
        this.clearPick();
        this.timeAware = true;
        this.xaxisTime = true;
        this.pickAware = true;
        this.xaxisScale = 1.0f;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String string) {
        this.subtitle = string;
    }

    public String getLabelX() {
        return this.labelX;
    }

    public void setLabelX(String string) {
        this.labelX = string;
    }

    public String getLabelY() {
        return this.labelY;
    }

    public void setLabelY(String string) {
        this.labelY = string;
    }

    public Grid getLabelGrid() {
        return this.labelGrid;
    }

    public int getNumX() {
        return this.numX;
    }

    public int getNumY() {
        return this.numY;
    }

    public Float getPickValueX() {
        return this.pickValueX;
    }

    public void setPickValueX(Float f) {
        this.pickValueX = f;
    }

    public Integer getPickIndexX() {
        return this.pickIndexX;
    }

    public void setPickIndexX(Integer n) {
        this.pickIndexX = n;
    }

    public boolean isTimeAware() {
        return this.timeAware;
    }

    public boolean isXaxisTime() {
        return this.xaxisTime;
    }

    public boolean isPickAware() {
        return this.pickAware;
    }

    public float getXaxisScale() {
        return this.xaxisScale;
    }

    public void clearPick() {
        this.pickValueX = null;
        this.pickIndexX = null;
    }

    public void parseLabelX() {
        if (this.labelX.startsWith("Time ")) {
            int n;
            int n2 = this.labelX.indexOf("(");
            String string = this.labelX.substring(n2 + 1, n = this.labelX.indexOf(")"));
            this.xaxisScale = string.equals("ns") ? 1000.0f : 1.0f;
        } else {
            this.timeAware = false;
            this.xaxisTime = false;
        }
    }

    public abstract float getX(int var1);

    public abstract void createLabelGrid();

    protected void refineLabelGrid() {
        int n;
        double d = this.labelGrid.getMinX();
        double d2 = this.labelGrid.getMaxX();
        double d3 = this.labelGrid.getMinY();
        double d4 = this.labelGrid.getMaxY();
        double d5 = this.labelGrid.getWidthX();
        double d6 = this.labelGrid.getWidthY();
        int n2 = this.labelGrid.getCountX();
        int n3 = this.labelGrid.getCountY();
        double d7 = Math.floor(Math.log10(d5));
        double d8 = Math.floor(Math.log10(d6));
        double d9 = Math.pow(10.0, d7);
        double d10 = Math.pow(10.0, d8);
        d5 = Math.ceil(d5 / d9) * d9;
        d6 = Math.ceil(d6 / d10) * d10;
        d = Math.floor(d / d9) * d9;
        d3 = Math.floor(d3 / d10) * d10;
        for (n = 0; n < n2 + 10; ++n) {
            if (!(d + (double)n * d5 >= d2)) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < n3 + 10; ++n) {
            if (!(d3 + (double)n * d6 >= d4)) continue;
            n3 = n;
            break;
        }
        this.labelGrid = new Grid();
        this.labelGrid.setMinX(d);
        this.labelGrid.setMinY(d3);
        this.labelGrid.setMaxX(d + d5 * (double)n2);
        this.labelGrid.setMaxY(d3 + d6 * (double)n3);
        this.labelGrid.setWidthX(d5);
        this.labelGrid.setWidthY(d6);
        this.labelGrid.setCountX(n2);
        this.labelGrid.setCountY(n3);
    }

    public void setTime(float f) {
        this.pickValueX = Float.valueOf(f /= this.xaxisScale);
        int n = this.findNearestX(f);
        if (this.getX(n) == f) {
            this.pickIndexX = n;
        }
    }

    public void picked(float f) {
        this.clearPick();
        int n = this.findNearestX(f);
        if (n >= 0) {
            this.pickIndexX = n;
            this.pickValueX = Float.valueOf(this.getX(n));
        }
    }

    public int findNearestX(float f) {
        float f2;
        if (this.numX == 0) {
            return -1;
        }
        int n = 0;
        int n2 = this.numX - 1;
        if (f < this.getX(n)) {
            return n;
        }
        if (f > this.getX(n2)) {
            return n2;
        }
        while (n2 - n > 1) {
            int n3 = (n2 + n) / 2;
            if (f < this.getX(n3)) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        float f3 = f - this.getX(n);
        return f3 <= (f2 = this.getX(n2) - f) ? n : n2;
    }
}

