/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import jp.riken.plot2d.data.PlotData;
import jp.riken.plot2d.data.PlotDataPcaEach;

public class PlotDataPca
extends PlotData {
    private int numT;
    private float[] times;
    private float[] pca1;
    private float[] pca2;
    private float[] pca3;
    private PlotDataPcaEach[] pcas;

    public PlotDataPca() {
        this.xaxisTime = false;
        this.pickAware = false;
        this.pcas = new PlotDataPcaEach[4];
        for (int i = 0; i < 4; ++i) {
            this.pcas[i] = new PlotDataPcaEach();
        }
    }

    @Override
    public float getX(int n) {
        return 0.0f;
    }

    @Override
    public void createLabelGrid() {
    }

    public void setup(int n) {
        this.numT = n;
        this.times = new float[n];
        this.pca1 = new float[n];
        this.pca2 = new float[n];
        this.pca3 = new float[n];
        this.pcas[0].setup(n, this.pca1, this.pca2);
        this.pcas[1].setup(n, this.pca3, this.pca2);
        this.pcas[2].setup(n, this.pca1, this.pca3);
        this.pcas[3].setup(n, this.pca1, this.pca1);
    }

    public void setPcaValue(int n, float f, float[] fArray) {
        this.times[n] = f;
        this.pca1[n] = fArray[0];
        this.pca2[n] = fArray[1];
        this.pca3[n] = fArray[2];
    }

    public int getNumT() {
        return this.numT;
    }

    public PlotDataPcaEach[] getPcas() {
        return this.pcas;
    }

    public void makeXpmData() {
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.POSITIVE_INFINITY;
        float f6 = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numT; ++i) {
            if (f > this.pca1[i]) {
                f = this.pca1[i];
            }
            if (f2 < this.pca1[i]) {
                f2 = this.pca1[i];
            }
            if (f3 > this.pca2[i]) {
                f3 = this.pca2[i];
            }
            if (f4 < this.pca2[i]) {
                f4 = this.pca2[i];
            }
            if (f5 > this.pca3[i]) {
                f5 = this.pca3[i];
            }
            if (!(f6 < this.pca3[i])) continue;
            f6 = this.pca3[i];
        }
        this.pcas[0].makeXpmData("PCA", "PC1", "PC2", f, f2, f3, f4);
        this.pcas[1].makeXpmData("", "PC3", "PC2", f5, f6, f3, f4);
        this.pcas[2].makeXpmData("", "PC1", "PC3", f, f2, f5, f6);
        this.pcas[3].makeXpmData("", "PC1", "PC1", f, f2, f, f2);
    }

    @Override
    public void setTime(float f) {
        int n = this.findNearestT(f);
        if (n < 0 || this.times[n] != f) {
            n = -1;
        }
        for (PlotDataPcaEach plotDataPcaEach : this.pcas) {
            plotDataPcaEach.setTimeIndex(n);
        }
    }

    private int findNearestT(float f) {
        if (this.numT == 0) {
            return -1;
        }
        int n = 0;
        int n2 = this.numT - 1;
        if (f < this.times[n]) {
            return n;
        }
        if (f > this.times[n2]) {
            return n2;
        }
        while (n2 - n > 1) {
            int n3 = (n2 + n) / 2;
            if (f < this.times[n3]) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        float f2 = f - this.times[n];
        float f3 = this.times[n2] - f;
        return f2 <= f3 ? n : n2;
    }
}

