/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.riken.common.exception.CustomException;
import jp.riken.plot2d.data.Grid;
import jp.riken.plot2d.data.PlotData;
import jp.riken.plot2d.data.PointValue;

public class PlotDataXpm
extends PlotData {
    private String legend = "";
    private float[] xaxis;
    private float[] yaxis;
    private int[][] indexes;
    private List<PointValue> values = new ArrayList<PointValue>();
    private Map<Character, Integer> valueMap = new HashMap<Character, Integer>();

    public void setup(int n, int n2) {
        this.numX = n;
        this.numY = n2;
        this.xaxis = new float[n];
        this.yaxis = new float[n2];
        this.indexes = new int[n][n2];
    }

    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String string) {
        this.legend = string;
    }

    public void setXaxis(int n, float f) {
        this.xaxis[n] = f;
    }

    public float getXaxis(int n) {
        return this.xaxis[n];
    }

    public void setYaxis(int n, float f) {
        this.yaxis[n] = f;
    }

    public float getYaxis(int n) {
        return this.yaxis[n];
    }

    @Override
    public float getX(int n) {
        return this.getXaxis(n);
    }

    public void addPointValue(PointValue pointValue) {
        this.valueMap.put(Character.valueOf(pointValue.getElement()), this.values.size());
        this.values.add(pointValue);
    }

    public int numPointValues() {
        return this.values.size();
    }

    public PointValue getPointValue(int n) {
        return this.values.get(n);
    }

    public void setValue(int n, int n2, char c) {
        if (this.valueMap.get(Character.valueOf(c)) == null) {
            throw new CustomException("unknown element: " + c);
        }
        this.indexes[n][n2] = this.valueMap.get(Character.valueOf(c));
    }

    public PointValue getValue(int n, int n2) {
        return this.values.get(this.indexes[n][n2]);
    }

    @Override
    public void createLabelGrid() {
        float f;
        float f2;
        float f3 = this.xaxis[0];
        float f4 = this.yaxis[0];
        float f5 = this.xaxis[this.numX - 1];
        float f6 = this.yaxis[this.numY - 1];
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        if (this.numX == 1) {
            f2 = 1.0f;
            f5 = f3 + 1.0f;
        } else {
            f2 = this.xaxis[1] - this.xaxis[0];
            while ((n = (int)((f5 - f3) / (f2 * (float)n4))) > 10) {
                ++n4;
            }
            f2 = (f5 - f3) / (float)n;
        }
        if (this.numY == 1) {
            f = 1.0f;
            f6 = f4 + 1.0f;
        } else {
            f = this.yaxis[1] - this.yaxis[0];
            while ((n2 = (int)((f6 - f4) / (f * (float)n3))) > 10) {
                ++n3;
            }
            f = (f6 - f4) / (float)n2;
        }
        this.labelGrid = new Grid();
        this.labelGrid.setMinX(f3);
        this.labelGrid.setMinY(f4);
        this.labelGrid.setMaxX(f5);
        this.labelGrid.setMaxY(f6);
        this.labelGrid.setWidthX(f2);
        this.labelGrid.setWidthY(f);
        this.labelGrid.setCountX(n);
        this.labelGrid.setCountY(n2);
        this.refineLabelGrid();
    }

    public boolean isHighlight(int n, int n2) {
        return false;
    }
}

