/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.data;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jp.riken.plot2d.data.Grid;
import jp.riken.plot2d.data.PlotData;

public class PlotDataXvg
extends PlotData {
    private List<float[]> points = new ArrayList<float[]>();
    private String[] legends;
    private Color[] colors;
    private float viewMinY;
    private float viewMaxY;

    public void setup(int n) {
        this.numY = n;
        this.legends = new String[n];
        this.colors = new Color[n];
        for (int i = 0; i < n; ++i) {
            this.legends[i] = "";
            if (i % 10 == 0) {
                this.colors[i] = Color.BLACK;
                continue;
            }
            if (i % 10 == 1) {
                this.colors[i] = new Color(249, 37, 0);
                continue;
            }
            if (i % 10 == 2) {
                this.colors[i] = new Color(70, 184, 109);
                continue;
            }
            if (i % 10 == 3) {
                this.colors[i] = new Color(142, 0, 204);
                continue;
            }
            if (i % 10 == 4) {
                this.colors[i] = new Color(49, 0, 178);
                continue;
            }
            if (i % 10 == 5) {
                this.colors[i] = new Color(255, 129, 25);
                continue;
            }
            if (i % 10 == 6) {
                this.colors[i] = new Color(228, 162, 11);
                continue;
            }
            if (i % 10 == 7) {
                this.colors[i] = new Color(116, 169, 214);
                continue;
            }
            if (i % 10 == 8) {
                this.colors[i] = new Color(188, 189, 194);
                continue;
            }
            if (i % 10 != 9) continue;
            this.colors[i] = new Color(211, 212, 155);
        }
    }

    public void addPoints(float[] fArray) {
        this.points.add(fArray);
        ++this.numX;
    }

    @Override
    public float getX(int n) {
        return this.points.get(n)[0];
    }

    public float getY(int n, int n2) {
        return this.points.get(n)[n2 + 1];
    }

    public String getLegend(int n) {
        return this.legends[n];
    }

    public void setLegend(int n, String string) {
        this.legends[n] = string;
    }

    public Color getColor(int n) {
        return this.colors[n];
    }

    public void setColor(int n, Color color) {
        this.colors[n] = color;
    }

    public float getViewMinY() {
        return this.viewMinY;
    }

    public void setViewMinY(float f) {
        this.viewMinY = f;
    }

    public float getViewMaxY() {
        return this.viewMaxY;
    }

    public void setViewMaxY(float f) {
        this.viewMaxY = f;
    }

    @Override
    public void createLabelGrid() {
        double d;
        int n;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        for (n = 0; n < this.numX; ++n) {
            float[] fArray = this.points.get(n);
            d = fArray[0];
            if (d > d2) {
                d2 = d;
            }
            if (d < d3) {
                d3 = d;
            }
            for (int i = 0; i < this.numY; ++i) {
                double d6 = fArray[i + 1];
                if (d6 > d4) {
                    d4 = d6;
                }
                if (!(d6 < d5)) continue;
                d5 = d6;
            }
        }
        if (d3 == d2) {
            d3 -= 1.0;
            d2 += 1.0;
        }
        if (d5 == d4) {
            d5 -= 1.0;
            d4 += 1.0;
        }
        n = 10;
        int n2 = 10;
        d = (d2 - d3) / (double)n;
        double d7 = (d4 - d5) / (double)n2;
        this.labelGrid = new Grid();
        this.labelGrid.setMinX(d3);
        this.labelGrid.setMinY(d5);
        this.labelGrid.setMaxX(d2);
        this.labelGrid.setMaxY(d4);
        this.labelGrid.setWidthX(d);
        this.labelGrid.setWidthY(d7);
        this.labelGrid.setCountX(n);
        this.labelGrid.setCountY(n2);
        this.refineLabelGrid();
        this.viewMinY = (float)this.labelGrid.getMinY();
        this.viewMaxY = (float)this.labelGrid.getMaxY();
    }

    public void recreateYlabelGrid(double d, double d2) {
        int n = 10;
        double d3 = (d2 - d) / (double)n;
        this.labelGrid.setMinY(d);
        this.labelGrid.setMaxY(d2);
        this.labelGrid.setWidthY(d3);
        this.labelGrid.setCountY(n);
        this.viewMinY = (float)this.labelGrid.getMinY();
        this.viewMaxY = (float)this.labelGrid.getMaxY();
    }
}

