/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.riken.common.api.Plot2d;
import jp.riken.common.api.Viewer;
import jp.riken.common.exception.CustomException;
import jp.riken.plot2d.data.DataFileReaderPca;
import jp.riken.plot2d.data.DataFileReaderXpm;
import jp.riken.plot2d.data.DataFileReaderXvg;
import jp.riken.plot2d.data.PlotData;
import jp.riken.plot2d.data.PlotDataXvg;
import jp.riken.plot2d.gui.GuiController;
import jp.riken.plot2d.gui.MousePickHandler;
import jp.riken.plot2d.gui.PlotPanel;
import jp.riken.plot2d.gui.YaxisRangeDialog;
import jp.riken.plot2d.renderer.ImageRenderer;
import jp.riken.plot2d.renderer.ImageRendererLine;
import jp.riken.plot2d.renderer.ImageRendererTile;
import jp.riken.plot2d.renderer.RenderingContext;

public class Plot2dFrame
extends JFrame
implements ActionListener,
GuiController,
Plot2d {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "";
    private static final int DEFAULT_WIDTH = 615;
    private static final int DEFAULT_HEIGHT = 475;
    private static final int PANEL_WIDTH = 600;
    private static final int PANEL_HEIGHT = 400;
    private Viewer viewer;
    private ImageRenderer renderer;
    private RenderingContext context;
    private PlotData data;
    private MousePickHandler mousePickHandler;
    private YaxisRangeDialog yaxisRangeDialog;
    private int plotWidth;
    private int plotHeight;
    private boolean standalone;
    private File currDir;
    private PlotPanel plotPanel;
    private JScrollPane scrollPane;
    private JMenuItem miFileOpenDataXVG;
    private JMenuItem miFileOpenDataXPM;
    private JMenuItem miFileOpenDataPCA;
    private JMenuItem miFileExit;
    private JRadioButtonMenuItem miXaxisFrame;
    private JRadioButtonMenuItem miXaxis100;
    private JRadioButtonMenuItem miXaxis200;
    private JRadioButtonMenuItem miXaxis400;
    private JRadioButtonMenuItem miXaxis800;
    private JRadioButtonMenuItem miXaxis1600;
    private JRadioButtonMenuItem miYaxisFrame;
    private JRadioButtonMenuItem miYaxis100;
    private JRadioButtonMenuItem miYaxis200;
    private JRadioButtonMenuItem miYaxis400;
    private JRadioButtonMenuItem miYaxis800;
    private JRadioButtonMenuItem miYaxis1600;
    private JMenuItem miYaxisRange;

    public Plot2dFrame(boolean bl) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.standalone = bl;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                Plot2dFrame.this.init();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Plot2dFrame.this.exit();
            }
        });
        this.setSize(615, 475);
        this.setTitle(TITLE);
        this.context = new RenderingContext();
        this.context.setRatioImageInitX(0.15);
        this.context.setRatioImageTermX(0.84);
        this.context.setRatioImageInitY(0.15);
        this.context.setRatioImageTermY(0.9);
        this.mousePickHandler = new MousePickHandler(this.context);
        this.createMenu();
        this.createComponents();
        if (bl) {
            this.currDir = new File(".");
        }
    }

    private void init() {
    }

    private void exit() {
        if (this.viewer != null) {
            this.viewer.removePlot2d(this);
        }
        this.dispose();
        if (this.standalone) {
            System.exit(0);
        }
    }

    @Override
    public void dispose() {
        if (this.yaxisRangeDialog != null) {
            this.yaxisRangeDialog.dispose();
        }
        super.dispose();
    }

    public void setCenterTo(Component component) {
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        Dimension dimension2 = this.getSize();
        this.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
    }

    public PlotData getData() {
        return this.data;
    }

    @Override
    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void setTime(float f) {
        if (this.data.isTimeAware()) {
            this.data.setTime(f);
            this.refreshImage();
        }
    }

    @Override
    public void mousePicked(int n, int n2) {
        Float f;
        if (this.data != null && this.data.isPickAware() && (f = this.mousePickHandler.picked(n, n2, this.data)) != null) {
            this.refreshImage();
            if (this.viewer != null && this.data.isXaxisTime()) {
                this.viewer.setTime(f.floatValue() * this.data.getXaxisScale());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem == this.miFileOpenDataXVG) {
                this.openDataXvg();
            } else if (jMenuItem == this.miFileOpenDataXPM) {
                this.openDataXpm();
            } else if (jMenuItem == this.miFileOpenDataPCA) {
                this.openDataPca();
            } else if (jMenuItem == this.miFileExit) {
                this.exit();
            } else if (jMenuItem == this.miXaxisFrame) {
                this.ampXaxis(0);
            } else if (jMenuItem == this.miXaxis100) {
                this.ampXaxis(100);
            } else if (jMenuItem == this.miXaxis200) {
                this.ampXaxis(200);
            } else if (jMenuItem == this.miXaxis400) {
                this.ampXaxis(400);
            } else if (jMenuItem == this.miXaxis800) {
                this.ampXaxis(800);
            } else if (jMenuItem == this.miXaxis1600) {
                this.ampXaxis(1600);
            } else if (jMenuItem == this.miYaxisFrame) {
                this.ampYaxis(0);
            } else if (jMenuItem == this.miYaxis100) {
                this.ampYaxis(100);
            } else if (jMenuItem == this.miYaxis200) {
                this.ampYaxis(200);
            } else if (jMenuItem == this.miYaxis400) {
                this.ampYaxis(400);
            } else if (jMenuItem == this.miYaxis800) {
                this.ampYaxis(800);
            } else if (jMenuItem == this.miYaxis1600) {
                this.ampYaxis(1600);
            } else if (jMenuItem == this.miYaxisRange) {
                this.changeYaxisRange();
            }
        }
        catch (CustomException customException) {
            this.handleCustomException(customException);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void refreshImage() {
        this.refreshImage(0.0, 0.0);
    }

    private void refreshImage(double d, double d2) {
        if (this.data != null) {
            int n = this.scrollPane.getHorizontalScrollBar().getValue();
            int n2 = this.scrollPane.getVerticalScrollBar().getValue();
            int n3 = this.scrollPane.getWidth();
            int n4 = this.scrollPane.getHeight();
            int n5 = this.plotWidth == 0 ? n3 : this.plotWidth;
            int n6 = this.plotHeight == 0 ? n4 : this.plotHeight;
            this.context.setWidth(n5);
            this.context.setHeight(n6 - 15);
            this.plotPanel.setPreferredSize(new Dimension(n5, n6));
            BufferedImage bufferedImage = this.renderer.render(this.data);
            this.plotPanel.setImage(bufferedImage);
            this.plotPanel.repaint();
            if (d > 0.0 && d2 > 0.0) {
                this.scrollPane.setViewportView(this.plotPanel);
                this.scrollPane.getHorizontalScrollBar().setValue(this.adjustScrollBar(n, d, n3, n5));
                this.scrollPane.getVerticalScrollBar().setValue(this.adjustScrollBar(n2, d2, n4, n6));
            }
        }
    }

    private int adjustScrollBar(int n, double d, int n2, int n3) {
        int n4 = (int)(d * (double)n + (d - 1.0) * (double)n2 / 2.0);
        if (n4 < 0) {
            return 0;
        }
        if (n4 > n3 - n2) {
            return n3 - n2;
        }
        return n4;
    }

    public void openDataXvg(File file) throws CustomException {
        String string = file.getName();
        if (string.lastIndexOf(".") != -1) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        this.setTitle(string);
        DataFileReaderXvg dataFileReaderXvg = new DataFileReaderXvg();
        this.data = dataFileReaderXvg.read(file);
        this.renderer = new ImageRendererLine(this.context);
        this.scaleWithFrame();
        this.refreshImage();
        this.miYaxisRange.setEnabled(true);
    }

    public void openDataXpm(File file) throws CustomException {
        String string = file.getName();
        if (string.lastIndexOf(".") != -1) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        this.setTitle(string);
        DataFileReaderXpm dataFileReaderXpm = new DataFileReaderXpm();
        this.data = dataFileReaderXpm.read(file);
        this.renderer = new ImageRendererTile(this.context, false);
        this.scaleWithFrame();
        this.refreshImage();
        this.miYaxisRange.setEnabled(false);
    }

    public void openDataPca(File file, float f, float f2) throws CustomException {
        String string = file.getName();
        if (string.lastIndexOf(".") != -1) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        this.setTitle(string);
        DataFileReaderPca dataFileReaderPca = new DataFileReaderPca();
        this.data = dataFileReaderPca.read(file, f, f2);
        this.renderer = new ImageRendererTile(this.context, true);
        this.scaleWithFrame();
        this.refreshImage();
        this.miYaxisRange.setEnabled(false);
    }

    private void openDataXvg() throws CustomException {
        File file = this.chooseFile();
        if (file != null) {
            this.openDataXvg(file);
        }
    }

    private void openDataXpm() throws CustomException {
        File file = this.chooseFile();
        if (file != null) {
            this.openDataXpm(file);
        }
    }

    private void openDataPca() throws CustomException {
        File file = this.chooseFile();
        if (file != null) {
            this.openDataPca(file, 10.0f, 10.0f);
        }
    }

    private File chooseFile() {
        JFileChooser jFileChooser = new JFileChooser(this.currDir);
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currDir = file.getParentFile();
            return file;
        }
        return null;
    }

    public void ampXaxis(int n) {
        int n2 = this.plotWidth == 0 ? this.scrollPane.getWidth() : this.plotWidth;
        this.plotWidth = 600 * n / 100;
        double d = (double)this.plotWidth / (double)n2;
        if (this.plotWidth == 0) {
            this.scrollPane.setHorizontalScrollBarPolicy(31);
        } else {
            this.scrollPane.setHorizontalScrollBarPolicy(30);
        }
        this.refreshImage(d, 1.0);
    }

    public void ampYaxis(int n) {
        int n2 = this.plotHeight == 0 ? this.scrollPane.getHeight() : this.plotHeight;
        this.plotHeight = 400 * n / 100;
        double d = (double)this.plotHeight / (double)n2;
        if (this.plotHeight == 0) {
            this.scrollPane.setVerticalScrollBarPolicy(21);
        } else {
            this.scrollPane.setVerticalScrollBarPolicy(20);
        }
        this.refreshImage(1.0, d);
    }

    public void changeYaxisRange() {
        if (this.data != null) {
            PlotDataXvg plotDataXvg = (PlotDataXvg)this.data;
            if (this.yaxisRangeDialog == null) {
                this.yaxisRangeDialog = new YaxisRangeDialog(this, "Y-axis range", true);
            }
            this.yaxisRangeDialog.initialize();
            this.yaxisRangeDialog.setMin(plotDataXvg.getViewMinY());
            this.yaxisRangeDialog.setMax(plotDataXvg.getViewMaxY());
            this.yaxisRangeDialog.setVisible(true);
            if (this.yaxisRangeDialog.isOk()) {
                float f = this.yaxisRangeDialog.getMin();
                float f2 = this.yaxisRangeDialog.getMax();
                plotDataXvg.recreateYlabelGrid(f, f2);
                this.refreshImage();
            }
            if (this.yaxisRangeDialog.isReset()) {
                plotDataXvg.createLabelGrid();
                this.refreshImage();
            }
        }
    }

    private void handleCustomException(CustomException customException) {
        JOptionPane.showMessageDialog(this, customException.getMessage(), "Warning", 2);
    }

    private void handleException(Exception exception) {
        String string = "Unexpected error has occurred.\n";
        if (exception.getMessage() != null) {
            string = string + "\n" + exception.getMessage();
        }
        JOptionPane.showMessageDialog(this, string, "Error", 0);
        exception.printStackTrace();
        this.exit();
    }

    private void createComponents() {
        this.plotPanel = new PlotPanel(this);
        this.scrollPane = new JScrollPane(this.plotPanel);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Plot2dFrame.this.refreshImage();
            }
        });
        this.scaleWithFrame();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.scrollPane, "Center");
    }

    private void scaleWithFrame() {
        this.plotWidth = 0;
        this.plotHeight = 0;
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.miXaxisFrame.setSelected(true);
        this.miYaxisFrame.setSelected(true);
    }

    private void createMenu() {
        JMenu jMenu = new JMenu("File");
        this.miFileOpenDataXVG = this.createMenuItem("Open XVG Data");
        this.miFileOpenDataXPM = this.createMenuItem("Open XPM Data");
        this.miFileOpenDataPCA = this.createMenuItem("Open PCA Data");
        this.miFileExit = this.createMenuItem("Exit");
        jMenu.add(this.miFileOpenDataXVG);
        jMenu.add(this.miFileOpenDataXPM);
        jMenu.add(this.miFileOpenDataPCA);
        jMenu.addSeparator();
        jMenu.add(this.miFileExit);
        JMenu jMenu2 = new JMenu("X-axis");
        this.miXaxisFrame = this.createCheckBoxMenuItem("frame width");
        this.miXaxis100 = this.createCheckBoxMenuItem("100% (600 pixel)");
        this.miXaxis200 = this.createCheckBoxMenuItem("200%");
        this.miXaxis400 = this.createCheckBoxMenuItem("400%");
        this.miXaxis800 = this.createCheckBoxMenuItem("800%");
        this.miXaxis1600 = this.createCheckBoxMenuItem("1600%");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.miXaxisFrame);
        buttonGroup.add(this.miXaxis100);
        buttonGroup.add(this.miXaxis200);
        buttonGroup.add(this.miXaxis400);
        buttonGroup.add(this.miXaxis800);
        buttonGroup.add(this.miXaxis1600);
        jMenu2.add(this.miXaxisFrame);
        jMenu2.add(this.miXaxis100);
        jMenu2.add(this.miXaxis200);
        jMenu2.add(this.miXaxis400);
        jMenu2.add(this.miXaxis800);
        jMenu2.add(this.miXaxis1600);
        JMenu jMenu3 = new JMenu("Y-axis");
        this.miYaxisFrame = this.createCheckBoxMenuItem("frame height");
        this.miYaxis100 = this.createCheckBoxMenuItem("100% (400 pixel)");
        this.miYaxis200 = this.createCheckBoxMenuItem("200%");
        this.miYaxis400 = this.createCheckBoxMenuItem("400%");
        this.miYaxis800 = this.createCheckBoxMenuItem("800%");
        this.miYaxis1600 = this.createCheckBoxMenuItem("1600%");
        this.miYaxisRange = this.createMenuItem("range");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.miYaxisFrame);
        buttonGroup2.add(this.miYaxis100);
        buttonGroup2.add(this.miYaxis200);
        buttonGroup2.add(this.miYaxis400);
        buttonGroup2.add(this.miYaxis800);
        buttonGroup2.add(this.miYaxis1600);
        jMenu3.add(this.miYaxisFrame);
        jMenu3.add(this.miYaxis100);
        jMenu3.add(this.miYaxis200);
        jMenu3.add(this.miYaxis400);
        jMenu3.add(this.miYaxis800);
        jMenu3.add(this.miYaxis1600);
        jMenu3.addSeparator();
        jMenu3.add(this.miYaxisRange);
        JMenuBar jMenuBar = new JMenuBar();
        if (this.standalone) {
            jMenuBar.add(jMenu);
            jMenuBar.add(Box.createRigidArea(new Dimension(20, 1)));
        }
        jMenuBar.add(jMenu2);
        jMenuBar.add(Box.createRigidArea(new Dimension(20, 1)));
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private JRadioButtonMenuItem createCheckBoxMenuItem(String string) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.addActionListener(this);
        return jRadioButtonMenuItem;
    }

    public static void main(String[] stringArray) {
        Plot2dFrame plot2dFrame = new Plot2dFrame(true);
        plot2dFrame.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(0.9f * (float)dimension.height);
        int n2 = (int)(0.9f * (float)dimension.width);
        int n3 = n < n2 ? n : n2;
        Dimension dimension2 = plot2dFrame.getSize();
        if (dimension2.height > n3 || dimension2.width > n3) {
            dimension2.height = n3;
            dimension2.width = n3;
            plot2dFrame.setSize(dimension2);
        }
        plot2dFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        plot2dFrame.setVisible(true);
    }
}

