/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import jp.riken.plot2d.gui.GuiController;

public class PlotPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private GuiController guiController;
    private BufferedImage image;
    private long ticks;
    private static final long CLICK_INTERVAL = 500L;

    public PlotPanel(GuiController guiController) {
        this.guiController = guiController;
        this.addMouseListener(this);
        this.setBackground(Color.WHITE);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.handleMousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.handleMouseReleased(mouseEvent);
    }

    private void handleMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiersEx() == 1024) {
            this.ticks = System.currentTimeMillis();
        }
    }

    private void handleMouseReleased(MouseEvent mouseEvent) {
        if (System.currentTimeMillis() - this.ticks < 500L) {
            this.guiController.mousePicked(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

