/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.common.gui.DialogBase;

public class YaxisRangeDialog
extends DialogBase
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private JTextField minText;
    private JTextField maxText;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonReset;
    private boolean ok;
    private boolean reset;

    public YaxisRangeDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.setDefaultCloseOperation(1);
    }

    public void initialize() {
        this.ok = false;
        this.reset = false;
    }

    public float getMin() {
        return Float.parseFloat(this.minText.getText());
    }

    public void setMin(float f) {
        this.minText.setText("" + f);
    }

    public float getMax() {
        return Float.parseFloat(this.maxText.getText());
    }

    public void setMax(float f) {
        this.maxText.setText("" + f);
    }

    public boolean isOk() {
        return this.ok;
    }

    public boolean isReset() {
        return this.reset;
    }

    private void toggleOkButton() {
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(this.validateInput());
        }
    }

    private boolean validateInput() {
        if (!this.hasValue(this.minText) || !this.isFloat(this.minText)) {
            return false;
        }
        return this.hasValue(this.maxText) && this.isFloat(this.maxText);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonOK) {
            this.ok = true;
            this.reset = false;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.ok = false;
            this.reset = false;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.buttonReset) {
            this.ok = false;
            this.reset = true;
            this.setVisible(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    protected void createComponent() {
        this.setSize(400, 180);
        this.setResizable(true);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        Font font = new Font("SansSerif", 0, 12);
        this.minText = this.createTextField(font, this, 90);
        this.maxText = this.createTextField(font, this, 90);
        this.buttonCancel = this.createButton("Cancel", font, this);
        this.buttonOK = this.createButton("  OK  ", font, this, this.buttonCancel.getPreferredSize());
        this.buttonOK.setEnabled(false);
        this.buttonReset = this.createButton("Reset", font, this, this.buttonCancel.getPreferredSize());
        this.buttonReset.setEnabled(true);
        Font font2 = new Font("SansSerif", 0, 12);
        JLabel jLabel = this.createLabel("Y-axis range: ", font2);
        JLabel jLabel2 = this.createLabel("min ", font2);
        JLabel jLabel3 = this.createLabel("max ", font2);
        JPanel jPanel = null;
        int n = 20;
        int n2 = 40;
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel2);
        jPanel.add(this.minText);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel.add(jLabel3);
        jPanel.add(this.maxText);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        container.add(Box.createVerticalGlue());
        jPanel = this.createPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.buttonOK);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.buttonCancel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.buttonReset);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        container.add(jPanel);
    }
}

