/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import jp.riken.plot2d.data.Grid;
import jp.riken.plot2d.data.PlotData;
import jp.riken.plot2d.renderer.RenderingContext;

public abstract class ImageRenderer {
    protected RenderingContext context;
    protected int w;
    protected int h;
    protected double x1;
    protected double x2;
    protected double y1;
    protected double y2;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected double sx;
    protected double sy;
    protected double ratio;
    protected NumberFormat formatter;

    public ImageRenderer(RenderingContext renderingContext) {
        this.context = renderingContext;
        this.formatter = NumberFormat.getNumberInstance();
        this.formatter.setMaximumFractionDigits(4);
        this.formatter.setMinimumFractionDigits(4);
        this.formatter.setGroupingUsed(false);
    }

    public BufferedImage render(PlotData plotData) {
        this.w = this.context.getWidth();
        this.h = this.context.getHeight();
        BufferedImage bufferedImage = new BufferedImage(this.w, this.h, 1);
        this.render(plotData, bufferedImage.createGraphics());
        return bufferedImage;
    }

    protected abstract void render(PlotData var1, Graphics2D var2);

    protected void readScale(Grid grid) {
        this.x1 = this.context.getImageInitX();
        this.x2 = this.context.getImageTermX();
        this.y1 = this.context.getImageInitY();
        this.y2 = this.context.getImageTermY();
        this.minX = grid.getMinX();
        this.maxX = grid.getMaxX();
        this.minY = grid.getMinY();
        this.maxY = grid.getMaxY();
        this.sx = (this.x2 - this.x1) / (this.maxX - this.minX);
        this.sy = (this.y2 - this.y1) / (this.maxY - this.minY);
        double d = (double)this.w / 700.0;
        double d2 = (double)this.h / 560.0;
        this.ratio = d < d2 ? d : d2;
    }

    protected void readScale(Grid grid, int n) {
        this.x1 = this.context.getImageInitX();
        this.x2 = this.context.getImageTermX();
        this.y1 = this.context.getImageInitY();
        this.y2 = this.context.getImageTermY();
        double d = this.x2 * 0.46;
        double d2 = this.y2 * 0.46;
        double d3 = d - this.x1;
        double d4 = d2 - this.y1;
        if (n == 0) {
            this.x2 = d;
            this.y1 = this.y2 - d4;
        } else if (n == 1) {
            this.x1 = this.x2 - d3;
            this.y1 = this.y2 - d4;
        } else if (n == 2) {
            this.x2 = d;
            this.y2 = d2;
        } else if (n == 3) {
            this.x1 = this.x2 - d3;
            this.y2 = d2;
        }
        this.minX = grid.getMinX();
        this.maxX = grid.getMaxX();
        this.minY = grid.getMinY();
        this.maxY = grid.getMaxY();
        this.sx = (this.x2 - this.x1) / (this.maxX - this.minX);
        this.sy = (this.y2 - this.y1) / (this.maxY - this.minY);
        double d5 = (double)this.w / 700.0;
        double d6 = (double)this.h / 560.0;
        this.ratio = d5 < d6 ? d5 : d6;
    }

    protected void renderBackground(Graphics2D graphics2D) {
        graphics2D.setColor(this.context.getBackgroundColor());
        graphics2D.fillRect(0, 0, this.w, this.h);
    }

    protected void renderFrame(Graphics2D graphics2D) {
        graphics2D.setColor(this.context.getFrameColor());
        graphics2D.drawRect((int)this.x1, (int)((double)this.h - this.y2), (int)(this.x2 - this.x1) + 1, (int)(this.y2 - this.y1) + 1);
    }

    protected void renderTitle(PlotData plotData, Graphics2D graphics2D) {
        int n = (int)(24.0 * this.ratio);
        Font font = new Font("Dialog", 0, n);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        String string = plotData.getTitle();
        int n2 = (int)((this.x2 - this.x1) / 2.0 + this.x1 - 0.5 * (double)fontMetrics.stringWidth(string));
        int n3 = (int)((double)this.h - this.y2 - 0.9 * (double)fontMetrics.getAscent());
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(font);
        graphics2D.drawString(string, n2, n3);
        int n4 = (int)(14.0 * this.ratio);
        Font font2 = new Font("Dialog", 0, n4);
        FontMetrics fontMetrics2 = graphics2D.getFontMetrics(font2);
        String string2 = plotData.getSubtitle();
        n2 = (int)((this.x2 - this.x1) / 2.0 + this.x1 - 0.5 * (double)fontMetrics2.stringWidth(string2));
        n3 = (int)((double)this.h - this.y2 - 0.2 * (double)fontMetrics.getAscent());
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(font2);
        graphics2D.drawString(string2, n2, n3);
    }

    protected void renderLabel(PlotData plotData, Graphics2D graphics2D, boolean bl) {
        graphics2D.setColor(Color.BLACK);
        Grid grid = plotData.getLabelGrid();
        double d = grid.getWidthX();
        double d2 = grid.getWidthY();
        int n = grid.getCountX();
        int n2 = grid.getCountY();
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            n3 = (int)(10.0 * this.ratio);
            n4 = (int)(18.0 * this.ratio);
        } else {
            n3 = (int)(14.0 * this.ratio);
            n4 = (int)(24.0 * this.ratio);
        }
        Font font = new Font("Dialog", 0, n3);
        Font font2 = new Font("Dialog", 0, n4);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        FontMetrics fontMetrics2 = graphics2D.getFontMetrics(font2);
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics2.getAscent();
        int n7 = 0;
        int n8 = 0;
        graphics2D.setFont(font);
        n8 = (int)((double)this.h - this.y1 + 1.5 * (double)n5);
        for (int i = 0; i <= n; ++i) {
            double d3 = (double)i * d;
            String string = this.formatValue(this.minX + d3);
            n7 = (int)(d3 * this.sx + this.x1 - (double)(fontMetrics.stringWidth(string) / 2));
            graphics2D.drawString(string, n7, n8);
        }
        String string = plotData.getLabelX();
        n7 = (int)((double)n * d * this.sx / 2.0 + this.x1 - (double)(fontMetrics2.stringWidth(string) / 2));
        graphics2D.setFont(font2);
        graphics2D.drawString(string, n7, n8 += n6);
        graphics2D.setFont(font);
        int n9 = Integer.MAX_VALUE;
        for (int i = 0; i <= n2; ++i) {
            double d4 = (double)i * d2;
            String string2 = this.formatValue(this.minY + d4);
            n7 = (int)(this.x1 - (double)fontMetrics.stringWidth(string2) - 0.5 * (double)n5);
            n8 = (int)((double)this.h - this.y1 - d4 * this.sy + 0.5 * (double)n5);
            if (n7 < n9) {
                n9 = n7;
            }
            graphics2D.drawString(string2, n7, n8);
        }
        String string3 = plotData.getLabelY();
        n9 = (int)((double)n9 - 0.7 * (double)n6);
        int n10 = (int)((double)this.h - (double)n2 * d2 * this.sy / 2.0 - this.y1 + (double)(fontMetrics2.stringWidth(string3) / 2));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n9, n10);
        affineTransform.rotate(-1.5707963267948966);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font2);
        graphics2D.drawString(string3, 0, 0);
        affineTransform.setToIdentity();
        graphics2D.setTransform(affineTransform);
    }

    protected void renderPickedLine(PlotData plotData, Graphics2D graphics2D) {
        double d;
        if (plotData.getPickValueX() != null && (d = (double)plotData.getPickValueX().floatValue()) >= this.minX && d <= this.maxX) {
            int n = (int)((d - this.minX) * this.sx + this.x1);
            int n2 = (int)((double)this.h - this.y1);
            int n3 = (int)((double)this.h - this.y2) + 1;
            graphics2D.setColor(new Color(225, 0, 178));
            graphics2D.drawLine(n, n2, n, n3);
        }
    }

    protected String formatValue(double d) {
        String string = this.formatter.format(d);
        if (string.indexOf(".") == -1) {
            return string;
        }
        int n = string.length() - 1;
        char c = string.charAt(n);
        while (c == '0') {
            c = string.charAt(--n);
        }
        if (c == '.') {
            --n;
        }
        return string.substring(0, n + 1);
    }
}

