/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import jp.riken.plot2d.data.PlotData;
import jp.riken.plot2d.data.PlotDataXvg;
import jp.riken.plot2d.renderer.ImageRenderer;
import jp.riken.plot2d.renderer.RenderingContext;

public class ImageRendererLine
extends ImageRenderer {
    public ImageRendererLine(RenderingContext renderingContext) {
        super(renderingContext);
    }

    @Override
    protected void render(PlotData plotData, Graphics2D graphics2D) {
        this.renderBackground(graphics2D);
        if (plotData == null) {
            return;
        }
        this.readScale(plotData.getLabelGrid());
        PlotDataXvg plotDataXvg = (PlotDataXvg)plotData;
        this.renderTitle(plotData, graphics2D);
        this.renderLabel(plotData, graphics2D, false);
        this.renderLine(plotDataXvg, graphics2D);
        this.renderLegend(plotDataXvg, graphics2D);
        this.renderFrame(graphics2D);
        this.renderPickedLine(plotData, graphics2D);
        this.renderPickedValue(plotDataXvg, graphics2D);
    }

    private void renderLine(PlotDataXvg plotDataXvg, Graphics2D graphics2D) {
        for (int i = 0; i < plotDataXvg.getNumY(); ++i) {
            int n = 0;
            int n2 = 0;
            for (int j = 0; j < plotDataXvg.getNumX(); ++j) {
                double d = plotDataXvg.getX(j);
                double d2 = plotDataXvg.getY(j, i);
                if (d2 < plotDataXvg.getLabelGrid().getMinY()) {
                    d2 = plotDataXvg.getLabelGrid().getMinY();
                }
                if (d2 > plotDataXvg.getLabelGrid().getMaxY()) {
                    d2 = plotDataXvg.getLabelGrid().getMaxY();
                }
                int n3 = (int)((d - this.minX) * this.sx + this.x1);
                int n4 = (int)((double)this.h - (d2 - this.minY) * this.sy - this.y1);
                graphics2D.setColor(plotDataXvg.getColor(i));
                if (j != 0) {
                    graphics2D.drawLine(n3, n4, n, n2);
                }
                n = n3;
                n2 = n4;
            }
        }
    }

    private void renderLegend(PlotDataXvg plotDataXvg, Graphics2D graphics2D) {
        int n = (int)(14.0 * this.ratio);
        Font font = new Font("Dialog", 0, n);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        for (int i = 0; i < plotDataXvg.getNumY(); ++i) {
            String string = plotDataXvg.getLegend(i);
            double d = plotDataXvg.getY(plotDataXvg.getNumX() - 1, i);
            int n2 = (int)(this.x2 + 0.5 * (double)fontMetrics.getHeight());
            int n3 = (int)((double)this.h - (d - this.minY) * this.sy - this.y1 + 0.7 * (double)fontMetrics.getAscent());
            graphics2D.setColor(plotDataXvg.getColor(i));
            graphics2D.setFont(font);
            graphics2D.drawString(string, n2, n3);
        }
    }

    private void renderPickedValue(PlotDataXvg plotDataXvg, Graphics2D graphics2D) {
        int n;
        if (plotDataXvg.getPickIndexX() == null) {
            return;
        }
        int n2 = (int)(14.0 * this.ratio);
        Font font = new Font("Dialog", 0, n2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n3 = fontMetrics.getAscent();
        int n4 = plotDataXvg.getPickIndexX();
        double d = plotDataXvg.getX(n4);
        int n5 = 0;
        for (n = 0; n < plotDataXvg.getNumY(); ++n) {
            double d2 = plotDataXvg.getY(n4, n);
            if (n == 0) {
                n5 = fontMetrics.stringWidth("x = ");
                n5 += 10 + fontMetrics.stringWidth(this.formatValue(d));
                n5 += fontMetrics.stringWidth("y = ");
            }
            n5 += 5 + fontMetrics.stringWidth(this.formatValue(d2));
        }
        n = 0;
        int n6 = (int)((double)this.h - this.y1 + 4.5 * (double)n3);
        for (int i = 0; i < plotDataXvg.getNumY(); ++i) {
            String string;
            double d3 = plotDataXvg.getY(n4, i);
            if (i == 0) {
                n = (int)((d - this.minX) * this.sx + this.x1);
                if ((n -= (int)((double)n5 * 0.5)) < (int)this.x1) {
                    n = (int)this.x1;
                } else if (n + n5 > (int)this.x2) {
                    n = (int)this.x2 - n5;
                }
                string = "x = ";
                graphics2D.setColor(Color.BLACK);
                graphics2D.setFont(font);
                graphics2D.drawString(string, n, n6);
                String string2 = this.formatValue(d);
                graphics2D.drawString(string2, n += fontMetrics.stringWidth(string), n6);
                String string3 = "y = ";
                graphics2D.drawString(string3, n += 10 + fontMetrics.stringWidth(string2), n6);
                n += fontMetrics.stringWidth(string3);
            }
            string = this.formatValue(d3);
            graphics2D.setColor(plotDataXvg.getColor(i));
            graphics2D.drawString(string, n, n6);
            n += 5 + fontMetrics.stringWidth(string);
        }
    }
}

