/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.plot2d.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import jp.riken.plot2d.data.PlotData;
import jp.riken.plot2d.data.PlotDataPca;
import jp.riken.plot2d.data.PlotDataPcaEach;
import jp.riken.plot2d.data.PlotDataXpm;
import jp.riken.plot2d.renderer.ImageRenderer;
import jp.riken.plot2d.renderer.RenderingContext;

public class ImageRendererTile
extends ImageRenderer {
    private boolean pca = false;

    public ImageRendererTile(RenderingContext renderingContext, boolean bl) {
        super(renderingContext);
        this.pca = bl;
    }

    @Override
    protected void render(PlotData plotData, Graphics2D graphics2D) {
        this.renderBackground(graphics2D);
        if (plotData == null) {
            return;
        }
        if (!this.pca) {
            this.readScale(plotData.getLabelGrid());
            PlotDataXpm plotDataXpm = (PlotDataXpm)plotData;
            this.renderTitle(plotDataXpm, graphics2D);
            this.renderLabel(plotData, graphics2D, this.pca);
            this.renderTile(plotDataXpm, graphics2D);
            this.renderLegend(plotDataXpm, graphics2D, this.pca);
            this.renderFrame(graphics2D);
            this.renderPickedLine(plotData, graphics2D);
            this.renderPickedValue(plotDataXpm, graphics2D);
        } else {
            PlotDataPca plotDataPca = (PlotDataPca)plotData;
            for (int i = 0; i < 4; ++i) {
                PlotDataPcaEach plotDataPcaEach = plotDataPca.getPcas()[i];
                this.readScale(plotDataPcaEach.getLabelGrid(), i);
                if (i == 0) {
                    this.renderTitle(plotDataPcaEach, graphics2D);
                }
                this.renderLabel(plotDataPcaEach, graphics2D, this.pca);
                this.renderTile(plotDataPcaEach, graphics2D);
                this.renderLegend(plotDataPcaEach, graphics2D, this.pca);
                this.renderFrame(graphics2D);
            }
        }
    }

    private void renderTile(PlotDataXpm plotDataXpm, Graphics2D graphics2D) {
        int n = (int)Math.ceil((this.x2 - this.x1) / (double)plotDataXpm.getNumX());
        int n2 = (int)Math.ceil((this.y2 - this.y1) / (double)plotDataXpm.getNumY());
        Color color = Color.WHITE;
        for (int i = 0; i < plotDataXpm.getNumX(); ++i) {
            for (int j = 0; j < plotDataXpm.getNumY(); ++j) {
                if (plotDataXpm.isHighlight(i, j)) {
                    graphics2D.setColor(color);
                } else {
                    graphics2D.setColor(plotDataXpm.getValue(i, j).getColor());
                }
                double d = (this.maxX - this.minX) / (double)plotDataXpm.getNumX();
                double d2 = (this.maxY - this.minY) / (double)plotDataXpm.getNumY();
                double d3 = this.minX + (double)i * d;
                double d4 = this.minY + (double)j * d2;
                int n3 = (int)((d3 - this.minX) * this.sx + this.x1);
                int n4 = (int)((double)this.h - (d4 - this.minY) * this.sy - this.y1);
                graphics2D.fillRect(n3, n4 -= n2, n, n2);
            }
        }
    }

    private void renderLegend(PlotDataXpm plotDataXpm, Graphics2D graphics2D, boolean bl) {
        int n;
        int n2 = 0;
        n2 = bl ? (int)Math.ceil((this.x2 - this.x1) / (double)plotDataXpm.numPointValues() * 0.7) : (int)Math.ceil((this.x2 - this.x1) / (double)plotDataXpm.numPointValues() * 0.25);
        int n3 = n2 < (n = (int)Math.ceil((this.y2 - this.y1) / (double)plotDataXpm.numPointValues())) ? n2 : n;
        int n4 = (int)(0.75 * (double)n3);
        if (n4 == 0) {
            n4 = 1;
        } else if (n4 > 12) {
            n4 = 12;
        }
        Font font = new Font("Dialog", 0, n4);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        for (int i = 0; i < plotDataXpm.numPointValues(); ++i) {
            String string = plotDataXpm.getPointValue(i).getLegend();
            int n5 = (int)(this.x2 + (double)(2 * fontMetrics.getHeight()));
            int n6 = (int)((double)this.h - this.y2 + (double)(i * fontMetrics.getHeight()));
            graphics2D.setColor(plotDataXpm.getPointValue(i).getColor());
            graphics2D.fillRect(n5, n6, fontMetrics.getHeight(), fontMetrics.getHeight());
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(n5, n6, fontMetrics.getHeight(), fontMetrics.getHeight());
            graphics2D.setFont(font);
            graphics2D.drawString(string, n5 += (int)(1.3 * (double)fontMetrics.getHeight()), n6 += fontMetrics.getAscent());
        }
    }

    private void renderPickedValue(PlotDataXpm plotDataXpm, Graphics2D graphics2D) {
        if (plotDataXpm.getPickIndexX() != null) {
            int n = (int)(14.0 * this.ratio);
            Font font = new Font("Dialog", 0, n);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n2 = fontMetrics.getAscent();
            float f = plotDataXpm.getXaxis(plotDataXpm.getPickIndexX());
            int n3 = (int)(((double)f - this.minX) * this.sx + this.x1);
            int n4 = (int)((double)this.h - this.y1 + 4.5 * (double)n2);
            String string = "x = ";
            graphics2D.setColor(Color.BLACK);
            graphics2D.setFont(font);
            graphics2D.drawString(string, n3, n4);
            String string2 = this.formatValue(f);
            graphics2D.drawString(string2, n3 += fontMetrics.stringWidth(string), n4);
        }
    }
}

