/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gromacs;

import java.io.BufferedReader;
import java.io.IOException;
import jp.riken.viewer.gromacs.GromacsMoleculeReader;

public class GromacsGroReader
extends GromacsMoleculeReader {
    private int positions;

    @Override
    protected void readAsReference(BufferedReader bufferedReader) throws IOException {
        this.positions = 0;
        String string = null;
        string = bufferedReader.readLine();
        if (string == null) {
            return;
        }
        this.processTitle(string);
        string = bufferedReader.readLine();
        if (string == null) {
            return;
        }
        int n = Integer.parseInt(string.trim());
        while ((string = bufferedReader.readLine()) != null) {
            if (this.positions == 0) {
                this.determinePositions(string);
                if (this.positions <= 0) {
                    return;
                }
            }
            this.processAtom(string);
            if (this.atomId != n) continue;
            break;
        }
    }

    private void processTitle(String string) {
        int n = string.indexOf("t=");
        this.title = n < 0 ? string.trim() : string.substring(0, n).trim();
    }

    private void determinePositions(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return;
        }
        int n2 = string.indexOf(".", n + 1);
        if (n2 < 0) {
            return;
        }
        this.positions = n2 - n;
    }

    private void processAtom(String string) {
        ++this.atomId;
        String string2 = string.substring(0, 5);
        if (this.residueIdColumn == null || !this.residueIdColumn.equals(string2)) {
            ++this.residueId;
            this.residueIdColumn = string2;
        }
        String string3 = string.substring(5, 10).trim().toUpperCase();
        string3 = this.fixResidueName(string3);
        if (!this.ligand && string3.equals("LIG")) {
            this.builder.breakChain();
            this.ligand = true;
        }
        if (!this.solvent && string3.equals("SOL")) {
            this.builder.breakChain();
            this.solvent = true;
        }
        String string4 = string.substring(10, 15).trim().toUpperCase();
        string4 = this.fixAtomName(string4);
        this.atomRecord.setId("" + this.atomId);
        this.atomRecord.setAuthAsymId(" ");
        this.atomRecord.setSeqId("" + this.residueId);
        this.atomRecord.setAltId("");
        this.atomRecord.setCompId(string3);
        this.atomRecord.setAtomId(string4);
        int n = 20;
        this.atomRecord.setCartnX("" + this.getCoord(string, n));
        this.atomRecord.setCartnY("" + this.getCoord(string, n += this.positions));
        this.atomRecord.setCartnZ("" + this.getCoord(string, n += this.positions));
        this.atomRecord.setBFactor("0");
        this.atomRecord.setInsCode(' ');
        char c = string4.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            this.atomRecord.setTypeSymbol(string4.substring(0, 2));
        } else {
            this.atomRecord.setTypeSymbol(string4.substring(1, 2));
        }
        this.builder.addAtomRecord(this.atomRecord, false);
    }

    private String fixResidueName(String string) {
        if (string.length() < 3) {
            String string2 = "  " + string;
            return string2.substring(string2.length() - 3);
        }
        return string;
    }

    private String fixAtomName(String string) {
        char c;
        int n;
        String string2 = "   " + string + "  ";
        for (n = 3; n < 7 && ((c = string2.charAt(n)) < 'A' || c > 'Z'); ++n) {
        }
        if (n == 7) {
            string2 = "   " + string;
            return string2.substring(string2.length() - 4);
        }
        if (n == 3 && string.length() == 4) {
            if (string2.charAt(3) == 'H' && string2.charAt(6) >= '0' && string2.charAt(6) <= '9') {
                return string2.charAt(6) + string2.substring(3, 6);
            }
            return string;
        }
        return string2.substring(n - 1, n + 3);
    }

    private float getCoord(String string, int n) {
        int n2 = n + this.positions;
        return Float.parseFloat(string.substring(n, n2).trim()) * 10.0f;
    }
}

