/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gromacs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jp.riken.common.exception.CustomException;
import jp.riken.viewer.gromacs.TrajectoryReaderOption;
import org.pdbj.viewer.moleculebuilders.AtomRecord;
import org.pdbj.viewer.moleculebuilders.MoleculeFileBuilder;
import org.pdbj.viewer.molecules.MoleculeFile;
import org.pdbj.viewer.molecules.MoleculeFileTraj;

public abstract class GromacsMoleculeReader {
    public final String RESIDUE_LIGAND = "LIG";
    public final String RESIDUE_SOLVENT = "SOL";
    protected MoleculeFileBuilder builder;
    protected AtomRecord atomRecord;
    protected int frame;
    protected int atomId;
    protected int residueId;
    protected String residueIdColumn;
    protected String title;
    protected boolean ligand;
    protected boolean solvent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoleculeFileTraj readAsReference(File file, TrajectoryReaderOption trajectoryReaderOption) {
        BufferedReader bufferedReader;
        this.builder = new MoleculeFileBuilder();
        this.builder.setPDBml(false);
        this.builder.setFilePath(file.getAbsolutePath());
        this.builder.setFilter((MoleculeFileBuilder.AtomFilter)trajectoryReaderOption);
        this.init();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            try {
                this.readAsReference(bufferedReader);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            throw new CustomException("Cannot read file: ", iOException);
        }
        catch (Exception exception) {
            throw new CustomException("Invalid contents: ", exception);
        }
        bufferedReader = this.builder.getResult(true);
        bufferedReader.setMoleculeName(this.title);
        return new MoleculeFileTraj((MoleculeFile)bufferedReader);
    }

    protected void init() {
        this.atomRecord = new AtomRecord();
        this.atomRecord.setMdlId("NO_MODEL_ID");
        this.frame = 0;
        this.atomId = 0;
        this.residueId = 0;
        this.residueIdColumn = null;
        this.title = null;
        this.ligand = false;
        this.solvent = false;
    }

    protected abstract void readAsReference(BufferedReader var1) throws IOException;
}

