/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gromacs;

import java.io.BufferedReader;
import java.io.IOException;
import jp.riken.viewer.gromacs.GromacsMoleculeReader;

public class GromacsPdbReader
extends GromacsMoleculeReader {
    @Override
    protected void readAsReference(BufferedReader bufferedReader) throws IOException {
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 6) {
                string = GromacsPdbReader.addSpace(string, 6);
            }
            if (string.substring(0, 6).equals("TITLE")) {
                this.processTitle(string);
                continue;
            }
            if (string.substring(0, 6).equals("MODEL ")) {
                ++this.frame;
                if (this.frame <= 1) continue;
                break;
            }
            if (string.substring(0, 6).equals("ATOM  ")) {
                this.processAtom(string);
                continue;
            }
            if (string.substring(0, 6).equals("TER   ")) {
                this.processTer(string);
                continue;
            }
            if (!string.substring(0, 6).equals("ENDMDL")) continue;
            break;
        }
    }

    private void processTitle(String string) {
        int n = string.indexOf("t=");
        this.title = n < 0 ? string.substring(10).trim() : string.substring(10, n).trim();
    }

    private void processAtom(String string) {
        ++this.atomId;
        String string2 = string.substring(22, 26);
        if (this.residueIdColumn == null || !this.residueIdColumn.equals(string2)) {
            ++this.residueId;
            this.residueIdColumn = string2;
        }
        String string3 = string.substring(17, 20).toUpperCase();
        if (!this.ligand && string3.equals("LIG")) {
            this.builder.breakChain();
            this.ligand = true;
        }
        if (!this.solvent && string3.equals("SOL")) {
            this.builder.breakChain();
            this.solvent = true;
        }
        this.atomRecord.setId("" + this.atomId);
        this.atomRecord.setAuthAsymId(string.substring(21, 22));
        this.atomRecord.setSeqId("" + this.residueId);
        this.atomRecord.setAltId(string.substring(16, 17).trim());
        this.atomRecord.setCompId(string3);
        this.atomRecord.setAtomId(string.substring(12, 16).toUpperCase());
        this.atomRecord.setCartnX(string.substring(30, 38).trim());
        this.atomRecord.setCartnY(string.substring(38, 46).trim());
        this.atomRecord.setCartnZ(string.substring(46, 54).trim());
        this.atomRecord.setBFactor(string.substring(60, 66).trim());
        this.atomRecord.setInsCode(string.charAt(26));
        char c = string.charAt(12);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            this.atomRecord.setTypeSymbol(string.substring(12, 14));
        } else {
            this.atomRecord.setTypeSymbol(string.substring(13, 14));
        }
        this.builder.addAtomRecord(this.atomRecord, false);
    }

    private void processTer(String string) {
        this.builder.breakChain();
    }

    private static String addSpace(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n - n2; ++i) {
                stringBuffer.append(' ');
            }
            string = string + stringBuffer.toString();
        }
        return string;
    }
}

