/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gromacs;

import java.io.File;
import java.util.List;
import jp.riken.lib.xdrfile.Xdrfile;
import jp.riken.lib.xdrfile.XdrfileFrame;
import jp.riken.lib.xdrfile.XdrfileXtc;
import jp.riken.viewer.gromacs.TrajectoryReaderOption;
import org.pdbj.viewer.exceptions.RecoverableException;
import org.pdbj.viewer.moleculebuilders.MoleculeFileBuilder;
import org.pdbj.viewer.molecules.Molecule;
import org.pdbj.viewer.molecules.MoleculeFileTraj;
import org.pdbj.viewer.molecules.MoleculeFrameData;
import org.pdbj.viewer.molecules.MoleculeTraj;

public class GromacsTrajectoryReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file, MoleculeFileTraj moleculeFileTraj, TrajectoryReaderOption trajectoryReaderOption) throws RecoverableException {
        MoleculeTraj moleculeTraj = (MoleculeTraj)moleculeFileTraj.getMolecule(0);
        Xdrfile xdrfile = new Xdrfile();
        try {
            xdrfile.openRead(file);
            XdrfileFrame xdrfileFrame = new XdrfileFrame();
            int n = 1;
            trajectoryReaderOption.startRead();
            while (XdrfileXtc.readXtc((Xdrfile)xdrfile, (XdrfileFrame)xdrfileFrame)) {
                if (n == trajectoryReaderOption.getNextValue()) {
                    if (n != trajectoryReaderOption.getStart()) {
                        moleculeTraj = moleculeFileTraj.addFrame();
                    }
                    this.setValues(moleculeTraj, xdrfileFrame, trajectoryReaderOption);
                    if (n == trajectoryReaderOption.getStart()) {
                        this.initializeSize(moleculeFileTraj);
                    }
                    System.out.println("read frame " + n);
                    if (!trajectoryReaderOption.hasNext()) break;
                    trajectoryReaderOption.next();
                }
                ++n;
            }
        }
        finally {
            xdrfile.close();
        }
    }

    private void setValues(MoleculeTraj moleculeTraj, XdrfileFrame xdrfileFrame, TrajectoryReaderOption trajectoryReaderOption) {
        moleculeTraj.setTime(xdrfileFrame.getTime());
        MoleculeFrameData moleculeFrameData = moleculeTraj.getCurrFrame();
        int n = xdrfileFrame.getNatoms();
        float[] fArray = xdrfileFrame.getX();
        float[] fArray2 = moleculeFrameData.getX();
        float[] fArray3 = moleculeFrameData.getY();
        float[] fArray4 = moleculeFrameData.getZ();
        List list = trajectoryReaderOption.getAtomFlags();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (((Boolean)list.get(i)).booleanValue()) {
                fArray2[n2] = fArray[n3++] * 10.0f;
                fArray3[n2] = fArray[n3++] * 10.0f;
                fArray4[n2] = fArray[n3++] * 10.0f;
                ++n2;
                continue;
            }
            n3 += 3;
        }
    }

    private void initializeSize(MoleculeFileTraj moleculeFileTraj) {
        Molecule molecule = moleculeFileTraj.getMolecule(0);
        MoleculeFileBuilder.initializeMolecule((Molecule)molecule);
        moleculeFileTraj.center().set(molecule.getCenterX(), molecule.getCenterY(), molecule.getCenterZ());
        moleculeFileTraj.setRadius(molecule.getRadius());
    }
}

