/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.riken.common.api.Plot2d;
import jp.riken.common.api.Viewer;
import jp.riken.common.exception.CustomException;
import jp.riken.plot2d.data.PlotDataXpm;
import jp.riken.plot2d.gui.Plot2dFrame;
import jp.riken.viewer.gromacs.GromacsGroReader;
import jp.riken.viewer.gromacs.GromacsMoleculeReader;
import jp.riken.viewer.gromacs.GromacsPdbReader;
import jp.riken.viewer.gromacs.GromacsTrajectoryReader;
import jp.riken.viewer.gromacs.TrajectoryReaderOption;
import jp.riken.viewer.gui.CommandFrame;
import jp.riken.viewer.gui.GromacsFileType;
import jp.riken.viewer.gui.OpenHbondDialog;
import jp.riken.viewer.gui.OpenPcaDialog;
import jp.riken.viewer.gui.OpenTrajectoryDialog;
import jp.riken.viewer.gui.TrajectoryControlPanel;
import jp.riken.viewer.gui.ViewerFrame;
import org.pdbj.viewer.molecules.MoleculeFile;

public class ApplicationFrame
extends ViewerFrame
implements Viewer {
    private static final long serialVersionUID = 1L;
    private float commonTime;
    private TrajectoryControlPanel trajectoryControlPanel;
    private OpenTrajectoryDialog openTrajectoryDialog;
    private OpenPcaDialog openPcaDialog;
    private OpenHbondDialog openHbondDialog;
    private CommandFrame commandFrame;
    private List<Plot2dFrame> plot2dFrames;
    private MenuItem miFileOpenTrajectory;
    private MenuItem miFileOpenXvg;
    private MenuItem miFileOpenXpm;
    private MenuItem miFileOpenPca;
    private MenuItem miFileOpenDssp;
    private MenuItem miFileOpenHbond;
    private MenuItem miFileOpenScript;
    private MenuItem miFileCloseAll;
    private MenuItem miFileCloseTrajectory;
    private MenuItem miFileSavePng;
    private MenuItem miFileSaveJpeg;
    private MenuItem miFileExit;
    private MenuItem miDisplayProteinWireframe;
    private MenuItem miDisplayProteinBackbone;
    private MenuItem miDisplayProteinStick;
    private MenuItem miDisplayProteinSpacefill;
    private MenuItem miDisplayProteinBallStick;
    private MenuItem miDisplayProteinRibbon;
    private MenuItem miDisplayProteinCartoon;
    private MenuItem miDisplayLigandWireframe;
    private MenuItem miDisplayLigandStick;
    private MenuItem miDisplayLigandSpacefill;
    private MenuItem miDisplayLigandBallStick;
    private MenuItem miDisplayLigandNeighborWireframe;
    private MenuItem miDisplayLigandNeighborStick;
    private MenuItem miDisplayLigandNeighborSpacefill;
    private MenuItem miDisplayLigandNeighborBallStick;
    private MenuItem miDisplayLigandNeighborOff;
    private MenuItem miDisplayLigandHbondDashedLine;
    private MenuItem miDisplayLigandHbondStick;
    private MenuItem miDisplayLigandHbondOff;
    private MenuItem miDisplaySolventWireframe;
    private MenuItem miDisplaySolventOff;
    private MenuItem miOptionCommandLine;
    private File currDir;

    public ApplicationFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.controller == null) {
            return;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ApplicationFrame.this.exit();
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                ApplicationFrame.this.init();
            }
        });
        this.setSize(new Dimension(700, 700));
        this.setTitle("");
        this.createComponent();
        this.createMenu();
        this.updateMenu();
        this.plot2dFrames = new ArrayList<Plot2dFrame>();
        this.currDir = new File(".");
    }

    private void init() {
        this.commandArea.setActive(true);
        this.commandArea.requestFocus();
        this.commandQueue.setActive(true);
        this.commandThread.start();
    }

    @Override
    public void dispose() {
        if (this.controller != null) {
            this.commandThread.terminate();
            try {
                this.commandThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.commandFrame != null) {
                this.commandFrame.dispose();
            }
            for (Plot2dFrame plot2dFrame : this.plot2dFrames) {
                plot2dFrame.dispose();
            }
            this.controller.dispose();
        }
        if (this.openTrajectoryDialog != null) {
            this.openTrajectoryDialog.dispose();
        }
        if (this.openPcaDialog != null) {
            this.openPcaDialog.dispose();
        }
        if (this.openHbondDialog != null) {
            this.openHbondDialog.dispose();
        }
        super.dispose();
    }

    @Override
    public void setTime(float f) {
        if (this.moleculeFile != null) {
            int n = this.trajectoryControlPanel.findNearestFrame(f);
            this.setTrajectoryFrame(n);
        }
        this.commonTime = f;
        this.sendTime();
    }

    @Override
    public void removePlot2d(Plot2d plot2d) {
        this.plot2dFrames.remove(plot2d);
    }

    public void updateTrajectoryFrame(int n) {
        if (this.moleculeFile != null) {
            this.setTrajectoryFrame(n);
            this.commonTime = this.moleculeFile.getMoleculeTraj(n).getTime();
            this.sendTime();
        }
    }

    private void setTrajectoryFrame(int n) {
        this.moleculeFile.setCurrentFrame(n);
        this.controller.refresh();
        this.trajectoryControlPanel.setFrame(n);
    }

    private void sendTime() {
        for (Plot2d plot2d : this.plot2dFrames) {
            plot2d.setTime(this.commonTime);
        }
    }

    public File chooseFile(GromacsFileType gromacsFileType, boolean bl) {
        int n;
        JFileChooser jFileChooser = new JFileChooser(this.currDir);
        jFileChooser.setMultiSelectionEnabled(false);
        if (gromacsFileType != null) {
            jFileChooser.setFileFilter(gromacsFileType);
        }
        if ((n = bl ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currDir = file.getParentFile();
            return file;
        }
        return null;
    }

    private void loadTrajectory() {
        try {
            File file = this.openTrajectoryDialog.getReferenceFile();
            File file2 = this.openTrajectoryDialog.getTrajectoryFile();
            TrajectoryReaderOption trajectoryReaderOption = this.openTrajectoryDialog.getOption();
            GromacsMoleculeReader gromacsMoleculeReader = null;
            String[] stringArray = file.getName().split("\\.");
            gromacsMoleculeReader = stringArray[stringArray.length - 1].equalsIgnoreCase("gro") ? new GromacsGroReader() : new GromacsPdbReader();
            this.moleculeFile = gromacsMoleculeReader.readAsReference(file, trajectoryReaderOption);
            this.moleculeFile.setAnimation(true);
            GromacsTrajectoryReader gromacsTrajectoryReader = new GromacsTrajectoryReader();
            gromacsTrajectoryReader.read(file2, this.moleculeFile, trajectoryReaderOption);
            this.controller.loadMoleculeFile((MoleculeFile)this.moleculeFile, true, null);
            this.trajectoryControlPanel.fileOpened(this.moleculeFile);
            this.updateTrajectoryFrame(0);
        }
        catch (Exception exception) {
            throw new CustomException(exception);
        }
    }

    private void closeTrajectory() {
        this.controller.closeAllFile();
        this.trajectoryControlPanel.fileClosed();
        this.moleculeFile = null;
    }

    private void createComponent() {
        this.trajectoryControlPanel = new TrajectoryControlPanel(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.controller.getCanvasL(), "Center");
        container.add((Component)this.trajectoryControlPanel, "South");
    }

    private void showOpenTrajectoryDialog() {
        if (this.openTrajectoryDialog == null) {
            this.openTrajectoryDialog = new OpenTrajectoryDialog(this, "Open Trajectory", true);
        }
        this.openTrajectoryDialog.initialize();
        this.openTrajectoryDialog.setVisible(true);
    }

    private void showOpenPcaDialog() {
        if (this.openPcaDialog == null) {
            this.openPcaDialog = new OpenPcaDialog(this, "Open PCA", true);
        }
        this.openPcaDialog.initialize();
        this.openPcaDialog.setVisible(true);
    }

    private void showOpenHbondDialog() {
        if (this.openHbondDialog == null) {
            this.openHbondDialog = new OpenHbondDialog(this, "Open H-bond", true);
        }
        this.openHbondDialog.initialize();
        this.openHbondDialog.setVisible(true);
    }

    private Plot2dFrame createAndShowPlot2dFrame() {
        Plot2dFrame plot2dFrame = new Plot2dFrame(false);
        this.plot2dFrames.add(plot2dFrame);
        plot2dFrame.setViewer(this);
        plot2dFrame.setCenterTo(this);
        plot2dFrame.setVisible(true);
        return plot2dFrame;
    }

    private void createMenu() {
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Open");
        this.miFileOpenTrajectory = this.createMenuItem("Trajectory");
        this.miFileOpenXvg = this.createMenuItem("XVG");
        this.miFileOpenXpm = this.createMenuItem("XPM");
        this.miFileOpenPca = this.createMenuItem("PCA");
        this.miFileOpenDssp = this.createMenuItem("DSSP");
        this.miFileOpenHbond = this.createMenuItem("H-bond");
        this.miFileOpenScript = this.createMenuItem("Script");
        menu2.add(this.miFileOpenTrajectory);
        menu2.add(this.miFileOpenXvg);
        menu2.add(this.miFileOpenXpm);
        menu2.add(this.miFileOpenPca);
        menu2.addSeparator();
        menu2.add(this.miFileOpenDssp);
        menu2.add(this.miFileOpenHbond);
        menu2.addSeparator();
        menu2.add(this.miFileOpenScript);
        menu.add(menu2);
        Menu menu3 = new Menu("Close");
        this.miFileCloseAll = this.createMenuItem("All");
        this.miFileCloseTrajectory = this.createMenuItem("Trajectory");
        menu3.add(this.miFileCloseAll);
        menu3.add(this.miFileCloseTrajectory);
        menu.add(menu3);
        Menu menu4 = new Menu("Save");
        this.miFileSavePng = this.createMenuItem("PNG");
        this.miFileSaveJpeg = this.createMenuItem("JPEG");
        menu4.add(this.miFileSavePng);
        menu4.add(this.miFileSaveJpeg);
        menu.add(menu4);
        menu.addSeparator();
        this.miFileExit = this.createMenuItem("Exit");
        menu.add(this.miFileExit);
        Menu menu5 = new Menu("Display");
        Menu menu6 = new Menu("Protein");
        this.miDisplayProteinWireframe = this.createMenuItem("Wireframe");
        this.miDisplayProteinBackbone = this.createMenuItem("Backbone");
        this.miDisplayProteinStick = this.createMenuItem("Stick");
        this.miDisplayProteinSpacefill = this.createMenuItem("Spacefill");
        this.miDisplayProteinBallStick = this.createMenuItem("Ball & Stick");
        this.miDisplayProteinRibbon = this.createMenuItem("Ribbon");
        this.miDisplayProteinCartoon = this.createMenuItem("Cartoon");
        menu6.add(this.miDisplayProteinWireframe);
        menu6.add(this.miDisplayProteinBackbone);
        menu6.add(this.miDisplayProteinStick);
        menu6.add(this.miDisplayProteinSpacefill);
        menu6.add(this.miDisplayProteinBallStick);
        menu6.add(this.miDisplayProteinRibbon);
        menu6.add(this.miDisplayProteinCartoon);
        menu5.add(menu6);
        Menu menu7 = new Menu("Ligand");
        this.miDisplayLigandWireframe = this.createMenuItem("Wireframe");
        this.miDisplayLigandStick = this.createMenuItem("Stick");
        this.miDisplayLigandSpacefill = this.createMenuItem("Spacefill");
        this.miDisplayLigandBallStick = this.createMenuItem("Ball & Stick");
        menu7.add(this.miDisplayLigandWireframe);
        menu7.add(this.miDisplayLigandStick);
        menu7.add(this.miDisplayLigandSpacefill);
        menu7.add(this.miDisplayLigandBallStick);
        menu5.add(menu7);
        Menu menu8 = new Menu("Ligand Neighbor");
        this.miDisplayLigandNeighborWireframe = this.createMenuItem("Wireframe");
        this.miDisplayLigandNeighborStick = this.createMenuItem("Stick");
        this.miDisplayLigandNeighborSpacefill = this.createMenuItem("Spacefill");
        this.miDisplayLigandNeighborBallStick = this.createMenuItem("Ball & Stick");
        this.miDisplayLigandNeighborOff = this.createMenuItem("Off");
        menu8.add(this.miDisplayLigandNeighborWireframe);
        menu8.add(this.miDisplayLigandNeighborStick);
        menu8.add(this.miDisplayLigandNeighborSpacefill);
        menu8.add(this.miDisplayLigandNeighborBallStick);
        menu8.add(this.miDisplayLigandNeighborOff);
        menu5.add(menu8);
        Menu menu9 = new Menu("Ligand H-bond");
        this.miDisplayLigandHbondDashedLine = this.createMenuItem("Dashed Line");
        this.miDisplayLigandHbondStick = this.createMenuItem("Stick");
        this.miDisplayLigandHbondOff = this.createMenuItem("Off");
        menu9.add(this.miDisplayLigandHbondDashedLine);
        menu9.add(this.miDisplayLigandHbondStick);
        menu9.add(this.miDisplayLigandHbondOff);
        menu5.add(menu9);
        Menu menu10 = new Menu("Solvent");
        this.miDisplaySolventWireframe = this.createMenuItem("Wireframe");
        this.miDisplaySolventOff = this.createMenuItem("Off");
        menu10.add(this.miDisplaySolventWireframe);
        menu10.add(this.miDisplaySolventOff);
        menu5.add(menu10);
        Menu menu11 = new Menu("Option");
        this.miOptionCommandLine = this.createMenuItem("Command Line");
        menu11.add(this.miOptionCommandLine);
        MenuBar menuBar = new MenuBar();
        menuBar.add(menu);
        menuBar.add(menu5);
        menuBar.add(menu11);
        this.setMenuBar(menuBar);
    }

    private MenuItem createMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationFrame.this.menuActionPerformed(actionEvent);
            }
        });
        return menuItem;
    }

    private void menuActionPerformed(ActionEvent actionEvent) {
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        try {
            if (menuItem == this.miFileOpenTrajectory) {
                this.showOpenTrajectoryDialog();
                if (this.openTrajectoryDialog.isOk()) {
                    this.loadTrajectory();
                }
            } else if (menuItem == this.miFileOpenXvg) {
                File file = this.chooseFile(GromacsFileType.XVG, false);
                if (file != null) {
                    Plot2dFrame plot2dFrame = this.createAndShowPlot2dFrame();
                    plot2dFrame.openDataXvg(file);
                    this.sendTime();
                }
            } else if (menuItem == this.miFileOpenXpm) {
                File file = this.chooseFile(GromacsFileType.XPM, false);
                if (file != null) {
                    Plot2dFrame plot2dFrame = this.createAndShowPlot2dFrame();
                    plot2dFrame.openDataXpm(file);
                    this.sendTime();
                }
            } else if (menuItem == this.miFileOpenPca) {
                this.showOpenPcaDialog();
                if (this.openPcaDialog.isOk()) {
                    File file = this.openPcaDialog.getPcaFile();
                    float f = this.openPcaDialog.getStart();
                    float f2 = this.openPcaDialog.getStep();
                    Plot2dFrame plot2dFrame = this.createAndShowPlot2dFrame();
                    plot2dFrame.openDataPca(file, f, f2);
                    this.sendTime();
                }
            } else if (menuItem == this.miFileOpenDssp) {
                File file = this.chooseFile(GromacsFileType.XPM, false);
                if (file != null) {
                    Plot2dFrame plot2dFrame = this.createAndShowPlot2dFrame();
                    plot2dFrame.openDataXpm(file);
                    this.processDssp((PlotDataXpm)plot2dFrame.getData());
                    this.sendTime();
                }
            } else if (menuItem == this.miFileOpenHbond) {
                this.showOpenHbondDialog();
                if (this.openHbondDialog.isOk()) {
                    File file = this.openHbondDialog.getIndexFile();
                    File file2 = this.openHbondDialog.getMapFile();
                    Plot2dFrame plot2dFrame = this.createAndShowPlot2dFrame();
                    plot2dFrame.openDataXpm(file2);
                    this.processHbond(file, (PlotDataXpm)plot2dFrame.getData());
                    this.sendTime();
                }
            } else if (menuItem == this.miFileOpenScript) {
                File file = this.chooseFile(null, false);
                if (file != null) {
                    this.loadScript(file);
                }
            } else if (menuItem == this.miFileCloseAll) {
                for (Plot2dFrame plot2dFrame : this.plot2dFrames) {
                    plot2dFrame.dispose();
                }
                this.plot2dFrames.clear();
                this.closeTrajectory();
            } else if (menuItem == this.miFileCloseTrajectory) {
                this.closeTrajectory();
            } else if (menuItem == this.miFileSavePng) {
                File file = this.chooseFile(GromacsFileType.PNG, true);
                if (file != null) {
                    this.savePng(file);
                }
            } else if (menuItem == this.miFileSaveJpeg) {
                File file = this.chooseFile(GromacsFileType.JPG, true);
                if (file != null) {
                    this.saveJpeg(file);
                }
            } else if (menuItem == this.miFileExit) {
                this.exit();
            } else if (menuItem == this.miDisplayProteinWireframe) {
                this.displayProteinWireframe();
            } else if (menuItem == this.miDisplayProteinBackbone) {
                this.displayProteinBackbone();
            } else if (menuItem == this.miDisplayProteinStick) {
                this.displayProteinStick();
            } else if (menuItem == this.miDisplayProteinSpacefill) {
                this.displayProteinSpacefill();
            } else if (menuItem == this.miDisplayProteinBallStick) {
                this.displayProteinBallStick();
            } else if (menuItem == this.miDisplayProteinRibbon) {
                this.displayProteinRibbon();
            } else if (menuItem == this.miDisplayProteinCartoon) {
                this.displayProteinCartoon();
            } else if (menuItem == this.miDisplayLigandWireframe) {
                this.displayLigandWireframe();
            } else if (menuItem == this.miDisplayLigandStick) {
                this.displayLigandStick();
            } else if (menuItem == this.miDisplayLigandSpacefill) {
                this.displayLigandSpacefill();
            } else if (menuItem == this.miDisplayLigandBallStick) {
                this.displayLigandBallStick();
            } else if (menuItem == this.miDisplayLigandNeighborWireframe) {
                this.displayLigandNeighborWireframe();
            } else if (menuItem == this.miDisplayLigandNeighborStick) {
                this.displayLigandNeighborStick();
            } else if (menuItem == this.miDisplayLigandNeighborSpacefill) {
                this.displayLigandNeighborSpacefill();
            } else if (menuItem == this.miDisplayLigandNeighborBallStick) {
                this.displayLigandNeighborBallStick();
            } else if (menuItem == this.miDisplayLigandNeighborOff) {
                this.displayLigandNeighborOff();
            } else if (menuItem == this.miDisplayLigandHbondDashedLine) {
                this.displayLigandHbondDashedLine();
            } else if (menuItem == this.miDisplayLigandHbondStick) {
                this.displayLigandHbondStick();
            } else if (menuItem == this.miDisplayLigandHbondOff) {
                this.displayLigandHbondOff();
            } else if (menuItem == this.miDisplaySolventWireframe) {
                this.displaySolventWireframe();
            } else if (menuItem == this.miDisplaySolventOff) {
                this.displaySolventOff();
            } else if (menuItem == this.miOptionCommandLine) {
                if (this.commandFrame == null) {
                    this.commandFrame = new CommandFrame(this.commandArea);
                    this.commandFrame.setCenterTo(this);
                }
                this.commandFrame.setVisible(true);
            }
        }
        catch (CustomException customException) {
            this.showWarning(customException);
        }
        catch (Exception exception) {
            this.showErrorAndExit(exception);
        }
    }

    @Override
    protected void updateMenu() {
    }

    public static void main(String[] stringArray) {
        ApplicationFrame applicationFrame = new ApplicationFrame();
        applicationFrame.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(0.9f * (float)dimension.height);
        int n2 = (int)(0.9f * (float)dimension.width);
        int n3 = n < n2 ? n : n2;
        Dimension dimension2 = applicationFrame.getSize();
        if (dimension2.height > n3 || dimension2.width > n3) {
            dimension2.height = n3;
            dimension2.width = n3;
            applicationFrame.setSize(dimension2);
        }
        applicationFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        if (applicationFrame.graphicsReady()) {
            applicationFrame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(applicationFrame, "Cannot find JOGL", "Error", 0);
            applicationFrame.dispose();
            System.exit(0);
        }
    }
}

