/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gui;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class GromacsFileType
extends FileFilter {
    public static final GromacsFileType GRO = new GromacsFileType(0);
    public static final GromacsFileType PDB = new GromacsFileType(1);
    public static final GromacsFileType REF = new GromacsFileType(2);
    public static final GromacsFileType XTC = new GromacsFileType(3);
    public static final GromacsFileType XVG = new GromacsFileType(4);
    public static final GromacsFileType XPM = new GromacsFileType(5);
    public static final GromacsFileType PCA = new GromacsFileType(6);
    public static final GromacsFileType PNG = new GromacsFileType(7);
    public static final GromacsFileType JPG = new GromacsFileType(8);
    public static final GromacsFileType NDX = new GromacsFileType(9);
    private static final String[][] EXTENSIONS = new String[][]{{"gro"}, {"pdb"}, {"gro", "pdb"}, {"xtc"}, {"xvg"}, {"xpm"}, {"gro"}, {"png"}, {"jpg", "jpeg"}, {"ndx"}};
    private int type;

    private GromacsFileType(int n) {
        this.type = n;
    }

    @Override
    public String getDescription() {
        if (EXTENSIONS[this.type].length == 0) {
            return "all files (*.*)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < EXTENSIONS[this.type].length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("*." + EXTENSIONS[this.type][i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory() || EXTENSIONS[this.type].length == 0) {
            return true;
        }
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            String string2 = string.substring(n + 1).toLowerCase();
            for (int i = 0; i < EXTENSIONS[this.type].length; ++i) {
                if (!string2.equals(EXTENSIONS[this.type][i])) continue;
                return true;
            }
        }
        return false;
    }
}

