/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.common.gui.DialogBase;
import jp.riken.viewer.gui.ApplicationFrame;
import jp.riken.viewer.gui.GromacsFileType;

public class OpenHbondDialog
extends DialogBase
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private ApplicationFrame applicationFrame;
    private JTextField indexFileText;
    private JTextField mapFileText;
    private JButton indexFileBrowse;
    private JButton mapFileBrowse;
    private JButton buttonOK;
    private JButton buttonCancel;
    private boolean ok;

    public OpenHbondDialog(ApplicationFrame applicationFrame, String string, boolean bl) {
        super(applicationFrame, string, bl);
        this.applicationFrame = applicationFrame;
        this.setDefaultCloseOperation(1);
    }

    public void initialize() {
        this.ok = false;
    }

    public File getIndexFile() {
        return new File(this.indexFileText.getText());
    }

    public File getMapFile() {
        return new File(this.mapFileText.getText());
    }

    public boolean isOk() {
        return this.ok;
    }

    private void toggleOkButton() {
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(this.validateInput());
        }
    }

    private boolean validateInput() {
        if (!this.hasValue(this.indexFileText)) {
            return false;
        }
        return this.hasValue(this.mapFileText);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.indexFileBrowse) {
            File file = this.applicationFrame.chooseFile(GromacsFileType.NDX, false);
            if (file != null) {
                this.indexFileText.setText(file.getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.mapFileBrowse) {
            File file = this.applicationFrame.chooseFile(GromacsFileType.XPM, false);
            if (file != null) {
                this.mapFileText.setText(file.getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.buttonOK) {
            this.ok = true;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.ok = false;
            this.setVisible(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    protected void createComponent() {
        this.setSize(500, 220);
        this.setResizable(true);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        Font font = new Font("SansSerif", 0, 12);
        this.indexFileText = this.createTextField(font, this);
        this.mapFileText = this.createTextField(font, this);
        this.indexFileBrowse = this.createButton("Browse...", font, this);
        this.mapFileBrowse = this.createButton("Browse...", font, this);
        this.buttonCancel = this.createButton("Cancel", font, this);
        this.buttonOK = this.createButton("  OK  ", font, this, this.buttonCancel.getPreferredSize());
        this.buttonOK.setEnabled(false);
        Font font2 = new Font("SansSerif", 0, 12);
        JLabel jLabel = this.createLabel("H-bond index file (.ndx): ", font2);
        JLabel jLabel2 = this.createLabel("H-bond map file (.xpm): ", font2);
        JPanel jPanel = null;
        int n = 20;
        int n2 = 40;
        int n3 = 20;
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(this.indexFileText);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.indexFileBrowse);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, n3)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel2);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(this.mapFileText);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.mapFileBrowse);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        container.add(jPanel);
        container.add(Box.createVerticalGlue());
        jPanel = this.createPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.buttonOK);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.buttonCancel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        container.add(jPanel);
    }
}

