/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.common.gui.DialogBase;
import jp.riken.viewer.gui.ApplicationFrame;
import jp.riken.viewer.gui.GromacsFileType;

public class OpenPcaDialog
extends DialogBase
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private ApplicationFrame applicationFrame;
    private JTextField pcaFileText;
    private JTextField startText;
    private JTextField stepText;
    private JButton pcaFileBrowse;
    private JButton buttonOK;
    private JButton buttonCancel;
    private boolean ok;

    public OpenPcaDialog(ApplicationFrame applicationFrame, String string, boolean bl) {
        super(applicationFrame, string, bl);
        this.applicationFrame = applicationFrame;
        this.setDefaultCloseOperation(1);
    }

    public void initialize() {
        this.ok = false;
    }

    public File getPcaFile() {
        return new File(this.pcaFileText.getText());
    }

    public float getStart() {
        return Float.parseFloat(this.startText.getText());
    }

    public float getStep() {
        return Float.parseFloat(this.stepText.getText());
    }

    public boolean isOk() {
        return this.ok;
    }

    private void toggleOkButton() {
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(this.validateInput());
        }
    }

    private boolean validateInput() {
        if (!this.hasValue(this.pcaFileText)) {
            return false;
        }
        if (!this.isFloat(this.startText)) {
            return false;
        }
        float f = this.getAsFloat(this.stepText, 0.0f);
        return !(f <= 0.0f);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pcaFileBrowse) {
            File file = this.applicationFrame.chooseFile(GromacsFileType.PCA, false);
            if (file != null) {
                this.pcaFileText.setText(file.getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.buttonOK) {
            this.ok = true;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.ok = false;
            this.setVisible(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    protected void createComponent() {
        this.setSize(500, 220);
        this.setResizable(true);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        Font font = new Font("SansSerif", 0, 12);
        this.pcaFileText = this.createTextField(font, this);
        this.startText = this.createTextField(font, this, 70);
        this.stepText = this.createTextField(font, this, 70);
        this.pcaFileBrowse = this.createButton("Browse...", font, this);
        this.buttonCancel = this.createButton("Cancel", font, this);
        this.buttonOK = this.createButton("  OK  ", font, this, this.buttonCancel.getPreferredSize());
        this.buttonOK.setEnabled(false);
        Font font2 = new Font("SansSerif", 0, 12);
        JLabel jLabel = this.createLabel("PCA file (.gro): ", font2);
        JLabel jLabel2 = this.createLabel("Time: ", font2);
        JLabel jLabel3 = this.createLabel("start (ps) ", font2);
        JLabel jLabel4 = this.createLabel("step (ps) ", font2);
        JPanel jPanel = null;
        int n = 20;
        int n2 = 40;
        int n3 = 20;
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(this.pcaFileText);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.pcaFileBrowse);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, n3)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel2);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel3);
        jPanel.add(this.startText);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel.add(jLabel4);
        jPanel.add(this.stepText);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        container.add(Box.createVerticalGlue());
        jPanel = this.createPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.buttonOK);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.buttonCancel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 10)));
        container.add(jPanel);
        this.startText.setText("0");
        this.stepText.setText("10");
    }
}

