/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.common.gui.DialogBase;
import jp.riken.viewer.gromacs.TrajectoryReaderOption;
import jp.riken.viewer.gui.ApplicationFrame;
import jp.riken.viewer.gui.GromacsFileType;
import org.pdbj.viewer.commands.SelectExprParser;
import org.pdbj.viewer.manipulators.SelectExpr;

public class OpenTrajectoryDialog
extends DialogBase
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private ApplicationFrame applicationFrame;
    private JTextField referenceFileText;
    private JTextField trajectoryFileText;
    private JTextField frameStartText;
    private JTextField frameEndText;
    private JTextField frameStepText;
    private JTextField filterText;
    private JButton referenceFileBrowse;
    private JButton trajectoryFileBrowse;
    private JButton buttonOK;
    private JButton buttonCancel;
    private File referenceFile;
    private File trajectoryFile;
    private TrajectoryReaderOption option;
    private boolean ok;

    public OpenTrajectoryDialog(ApplicationFrame applicationFrame, String string, boolean bl) {
        super(applicationFrame, string, bl);
        this.applicationFrame = applicationFrame;
        this.setDefaultCloseOperation(1);
    }

    public void initialize() {
        this.referenceFile = null;
        this.trajectoryFile = null;
        this.option = null;
        this.ok = false;
    }

    public File getReferenceFile() {
        return this.referenceFile;
    }

    public File getTrajectoryFile() {
        return this.trajectoryFile;
    }

    public TrajectoryReaderOption getOption() {
        return this.option;
    }

    public boolean isOk() {
        return this.ok;
    }

    private void toggleOkButton() {
        if (this.buttonOK != null) {
            this.buttonOK.setEnabled(this.validateInput());
        }
    }

    private boolean validateInput() {
        int n;
        if (!this.hasValue(this.referenceFileText)) {
            return false;
        }
        if (!this.hasValue(this.trajectoryFileText)) {
            return false;
        }
        if (!this.hasValue(this.frameStartText)) {
            return false;
        }
        int n2 = this.getAsInt(this.frameStartText, -1);
        if (n2 < 1) {
            return false;
        }
        if (this.hasValue(this.frameEndText) && (n = this.getAsInt(this.frameEndText, -1)) < n2) {
            return false;
        }
        if (!this.hasValue(this.frameStepText)) {
            return false;
        }
        n = this.getAsInt(this.frameStepText, -1);
        return n >= 1;
    }

    private boolean takeValues() {
        SelectExpr selectExpr = null;
        if (this.hasValue(this.filterText)) {
            SelectExprParser selectExprParser = new SelectExprParser();
            try {
                selectExpr = selectExprParser.parseAsFilter(this.filterText.getText().trim());
                if (selectExpr == null) {
                    this.showError("Invalid filter expression.");
                    return false;
                }
            }
            catch (SelectExprParser.InvalidFilterException invalidFilterException) {
                this.showError(invalidFilterException.getMessage());
                return false;
            }
        }
        this.referenceFile = new File(this.referenceFileText.getText());
        this.trajectoryFile = new File(this.trajectoryFileText.getText());
        this.option = new TrajectoryReaderOption();
        this.option.setStart(Integer.parseInt(this.frameStartText.getText().trim()));
        if (this.hasValue(this.frameEndText)) {
            this.option.setEnd(Integer.parseInt(this.frameEndText.getText().trim()));
        } else {
            this.option.setEnd(-1);
        }
        this.option.setStep(Integer.parseInt(this.frameStepText.getText().trim()));
        this.option.setExpr(selectExpr);
        return true;
    }

    private boolean showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Warning", 2);
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.referenceFileBrowse) {
            File file = this.applicationFrame.chooseFile(GromacsFileType.REF, false);
            if (file != null) {
                this.referenceFileText.setText(file.getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.trajectoryFileBrowse) {
            File file = this.applicationFrame.chooseFile(GromacsFileType.XTC, false);
            if (file != null) {
                this.trajectoryFileText.setText(file.getAbsolutePath());
            }
        } else if (actionEvent.getSource() == this.buttonOK) {
            if (this.takeValues()) {
                this.ok = true;
                this.setVisible(false);
            }
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.ok = false;
            this.setVisible(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.toggleOkButton();
    }

    @Override
    protected void createComponent() {
        this.setSize(500, 400);
        this.setResizable(true);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        Font font = new Font("SansSerif", 0, 12);
        this.referenceFileText = this.createTextField(font, this);
        this.trajectoryFileText = this.createTextField(font, this);
        this.frameStartText = this.createTextField(font, this, 70);
        this.frameEndText = this.createTextField(font, this, 70);
        this.frameStepText = this.createTextField(font, this, 70);
        this.filterText = this.createTextField(font, null);
        this.referenceFileBrowse = this.createButton("Browse...", font, this);
        this.trajectoryFileBrowse = this.createButton("Browse...", font, this);
        this.buttonCancel = this.createButton("Cancel", font, this);
        this.buttonOK = this.createButton("  OK  ", font, this, this.buttonCancel.getPreferredSize());
        this.buttonOK.setEnabled(false);
        Font font2 = new Font("SansSerif", 0, 12);
        Font font3 = new Font("SansSerif", 0, 12);
        JLabel jLabel = this.createLabel("Reference file (.pdb, .gro): ", font2);
        JLabel jLabel2 = this.createLabel("* files with unknown extensions are read as PDB.", font3);
        JLabel jLabel3 = this.createLabel("Trajectory file (.xtc): ", font2);
        JLabel jLabel4 = this.createLabel("* files with unknown extensions are read as XTC.", font3);
        JLabel jLabel5 = this.createLabel("Frames: ", font2);
        JLabel jLabel6 = this.createLabel("start ", font2);
        JLabel jLabel7 = this.createLabel("end ", font2);
        JLabel jLabel8 = this.createLabel("step ", font2);
        JLabel jLabel9 = this.createLabel("* leave end field empty to read through the last frame.", font3);
        JLabel jLabel10 = this.createLabel("Filter: ", font2);
        JLabel jLabel11 = this.createLabel("atom expression ", font2);
        JLabel jLabel12 = this.createLabel("* !SOL means that only atoms not in residue SOL are read in.", font2);
        JPanel jPanel = null;
        int n = 20;
        int n2 = 40;
        int n3 = 20;
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(this.referenceFileText);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.referenceFileBrowse);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel2);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, n3)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel3);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(this.trajectoryFileText);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.trajectoryFileBrowse);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel4);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, n3)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel5);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel6);
        jPanel.add(this.frameStartText);
        jPanel.add(Box.createRigidArea(new Dimension(40, 1)));
        jPanel.add(jLabel7);
        jPanel.add(this.frameEndText);
        jPanel.add(Box.createRigidArea(new Dimension(40, 1)));
        jPanel.add(jLabel8);
        jPanel.add(this.frameStepText);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel9);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, n3)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n, 1)));
        jPanel.add(jLabel10);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel11);
        jPanel.add(this.filterText);
        jPanel.add(Box.createRigidArea(new Dimension(20, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(n2, 1)));
        jPanel.add(jLabel12);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        container.add(Box.createVerticalGlue());
        jPanel = this.createPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.buttonOK);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.buttonCancel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        container.add(jPanel);
        jPanel = this.createPanel();
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        container.add(jPanel);
        this.frameStartText.setText("1");
        this.frameStepText.setText("1");
        this.filterText.setText("!SOL");
    }
}

