/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gui;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.viewer.gui.ApplicationFrame;
import org.pdbj.viewer.molecules.MoleculeFileTraj;

public class TrajectoryControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ApplicationFrame applicationFrame;
    private float[] times;
    private JSpinner spinnerFrame;
    private JSlider sliderFrame;
    private JLabel labelTimeValue;
    private boolean ignoreEvent;

    public TrajectoryControlPanel(ApplicationFrame applicationFrame) {
        this.applicationFrame = applicationFrame;
        this.createComponent();
    }

    public void fileOpened(MoleculeFileTraj moleculeFileTraj) {
        int n = moleculeFileTraj.numMolecules();
        this.times = new float[n];
        for (int i = 0; i < n; ++i) {
            this.times[i] = moleculeFileTraj.getMoleculeTraj(i).getTime();
        }
        this.ignoreEvent = true;
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.spinnerFrame.getModel();
        spinnerNumberModel.setMaximum(Integer.valueOf(n));
        this.sliderFrame.setMaximum(n);
        this.spinnerFrame.setEnabled(true);
        this.sliderFrame.setEnabled(true);
        this.labelTimeValue.setText("" + this.times[0]);
        this.ignoreEvent = false;
    }

    public void fileClosed() {
        this.ignoreEvent = true;
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.spinnerFrame.getModel();
        spinnerNumberModel.setMaximum(Integer.valueOf(1));
        spinnerNumberModel.setValue(1);
        this.sliderFrame.setMaximum(1);
        this.sliderFrame.setValue(1);
        this.spinnerFrame.setEnabled(false);
        this.sliderFrame.setEnabled(false);
        this.labelTimeValue.setText("");
        this.ignoreEvent = false;
        this.times = null;
    }

    public void setFrame(int n) {
        this.ignoreEvent = true;
        ((SpinnerNumberModel)this.spinnerFrame.getModel()).setValue(n + 1);
        this.sliderFrame.setValue(n + 1);
        this.labelTimeValue.setText("" + this.times[n]);
        this.ignoreEvent = false;
    }

    public int findNearestFrame(float f) {
        int n = 0;
        int n2 = this.times.length - 1;
        if (f <= this.times[n]) {
            return n;
        }
        if (f >= this.times[n2]) {
            return n2;
        }
        while (n2 - n > 1) {
            int n3 = (n2 + n) / 2;
            if (f < this.times[n3]) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        float f2 = f - this.times[n];
        float f3 = this.times[n2] - f;
        return f2 <= f3 ? n : n2;
    }

    private void createComponent() {
        this.spinnerFrame = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
        this.spinnerFrame.setMinimumSize(new Dimension(60, 20));
        this.spinnerFrame.setMaximumSize(new Dimension(60, 20));
        this.spinnerFrame.setPreferredSize(new Dimension(60, 20));
        this.spinnerFrame.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TrajectoryControlPanel.this.spinnerFrameStateChanged(changeEvent);
            }
        });
        this.sliderFrame = new JSlider();
        this.sliderFrame.setMinimum(1);
        this.sliderFrame.setMaximum(1);
        this.sliderFrame.setValue(1);
        this.sliderFrame.setSnapToTicks(true);
        this.sliderFrame.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TrajectoryControlPanel.this.sliderFrameStateChanged(changeEvent);
            }
        });
        JLabel jLabel = new JLabel(" Frame: ");
        JLabel jLabel2 = new JLabel(" Time (ps): ");
        this.labelTimeValue = new JLabel("");
        this.labelTimeValue.setMinimumSize(new Dimension(80, 20));
        this.labelTimeValue.setMaximumSize(new Dimension(80, 20));
        this.labelTimeValue.setPreferredSize(new Dimension(80, 20));
        this.setLayout(new BoxLayout(this, 0));
        this.add(jLabel);
        this.add(this.spinnerFrame);
        this.add(this.sliderFrame);
        this.add(jLabel2);
        this.add(this.labelTimeValue);
        this.spinnerFrame.setEnabled(false);
        this.sliderFrame.setEnabled(false);
    }

    private void spinnerFrameStateChanged(ChangeEvent changeEvent) {
        if (!this.ignoreEvent) {
            this.applicationFrame.updateTrajectoryFrame((Integer)this.spinnerFrame.getValue() - 1);
        }
    }

    private void sliderFrameStateChanged(ChangeEvent changeEvent) {
        if (!this.ignoreEvent) {
            this.applicationFrame.updateTrajectoryFrame(this.sliderFrame.getValue() - 1);
        }
    }
}

