/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.viewer.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLProfile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.riken.common.exception.CustomException;
import jp.riken.plot2d.data.PlotDataXpm;
import jp.riken.plot2d.data.PointValue;
import org.pdbj.viewer.commands.CommandComplement;
import org.pdbj.viewer.commands.CommandExecutor;
import org.pdbj.viewer.commands.CommandTokenizer;
import org.pdbj.viewer.commands.Context;
import org.pdbj.viewer.commands.GuiController;
import org.pdbj.viewer.commands.SelectExprParser;
import org.pdbj.viewer.controller.FileStatus;
import org.pdbj.viewer.controller.ViewerController;
import org.pdbj.viewer.exceptions.ExceptionUtil;
import org.pdbj.viewer.exceptions.FatalException;
import org.pdbj.viewer.exceptions.RecoverableException;
import org.pdbj.viewer.gui.CommandArea;
import org.pdbj.viewer.gui.CommandHandler;
import org.pdbj.viewer.gui.CommandQueue;
import org.pdbj.viewer.gui.CommandThread;
import org.pdbj.viewer.gui.CommandType;
import org.pdbj.viewer.gui.FileLocator;
import org.pdbj.viewer.gui.FileType;
import org.pdbj.viewer.gui.GuiWrapper;
import org.pdbj.viewer.gui.UrlDialog;
import org.pdbj.viewer.manipulators.ColorExpr;
import org.pdbj.viewer.molecules.Atom;
import org.pdbj.viewer.molecules.Chain;
import org.pdbj.viewer.molecules.HBond;
import org.pdbj.viewer.molecules.MoleculeFileTraj;
import org.pdbj.viewer.molecules.MoleculeTraj;
import org.pdbj.viewer.molecules.Residue;
import org.pdbj.viewer.mouse.MouseBehavior;
import org.pdbj.viewer.mouse.MousePickListener;
import org.pdbj.viewer.mouse.PickResult;
import org.pdbj.viewer.renderer.RendererListener;
import org.pdbj.viewer.utils.ColorManager;
import org.pdbj.viewer.utils.MessageArea;
import org.pdbj.viewer.utils.MessageListener;
import org.pdbj.viewer.writers.ImageFileWriter;

public abstract class ViewerFrame
extends JFrame
implements CommandHandler,
GuiWrapper,
RendererListener,
MousePickListener {
    private static final long serialVersionUID = 1L;
    protected MoleculeFileTraj moleculeFile;
    protected ViewerController controller;
    protected MouseBehavior mouseBehavior;
    protected CommandArea commandArea;
    protected CommandQueue commandQueue;
    protected CommandThread commandThread;
    protected CommandExecutor executor;
    private SelectExprParser parser;
    private Context context;
    private boolean screenInitialized;

    public ViewerFrame() {
        try {
            this.controller = new ViewerController((RendererListener)this, false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        this.controller.stopRenderer();
        this.commandArea = new CommandArea((GuiWrapper)this);
        this.commandArea.setCommandHandler((CommandHandler)this);
        this.mouseBehavior = new MouseBehavior(this.controller, (MousePickListener)this);
        this.mouseBehavior.setMessageArea((MessageArea)this.commandArea);
        this.executor = new CommandExecutor(this.controller, this.mouseBehavior, (GuiController)this, null);
        this.executor.setMessageArea((MessageArea)this.commandArea);
        this.commandQueue = new CommandQueue();
        this.commandThread = new CommandThread((GuiWrapper)this, this.commandQueue, this.executor);
        this.parser = new SelectExprParser();
        this.context = new Context(this.controller, this.mouseBehavior, (GuiController)this, null);
    }

    public boolean graphicsReady() {
        return this.controller != null && this.controller.graphicsReady();
    }

    public void screenInitialized() {
    }

    public void screenDrawed() {
        if (!this.screenInitialized) {
            this.commandQueue.putCommand("", new CommandType(1));
            this.screenInitialized = true;
        }
    }

    public void screenResized(int n, int n2, int n3, int n4) {
    }

    public void executeSingleCommand(String string) {
        this.commandQueue.putCommand(string);
    }

    public CommandComplement complementCommand(String string) {
        return this.executor.complement(string);
    }

    public boolean isScriptMode() {
        return false;
    }

    public void loadPDBFile(String string, FileStatus fileStatus) {
    }

    public void loadPDBmlFile(String string, FileStatus fileStatus) {
    }

    public void loadPolygonFile(String string, FileStatus fileStatus) {
    }

    public void loadPolygonCgoFile(String string, FileStatus fileStatus) {
    }

    public void loadScriptFile(String string) {
        this.loadScript(new File(string));
    }

    public void loadAnimationFile(String string, FileStatus fileStatus) {
    }

    public void loadPDBmlFileFtp(String string, FileStatus fileStatus) {
    }

    public void loadEfsite(String string) {
    }

    public void savePDBFile(String string) {
    }

    public void saveScriptFile(String string) {
    }

    public void savePngFile(String string, float f) {
        this.savePng(new File(string));
    }

    public void saveJpegFile(String string, float f, float f2) {
        this.saveJpeg(new File(string));
    }

    public void pauseScript() {
    }

    public void setupStereo() {
    }

    public void exit() {
        this.dispose();
        System.exit(0);
    }

    public MessageListener getFtpMessageListener() {
        return null;
    }

    public boolean isStandalone() {
        return true;
    }

    public void loadFunctionFtp(FileStatus fileStatus) {
    }

    public HashMap getSiteUrlMap() {
        return this.controller.getSiteUrlMap().getMap();
    }

    public void loadSiteList(FileStatus fileStatus, String string) {
    }

    public Dimension getImageSize() {
        return this.controller.getCanvasL().getSize();
    }

    public Dimension setImageSize(Dimension dimension) {
        int n = dimension.width;
        int n2 = dimension.height;
        if (n < 10) {
            n = 10;
        }
        if (n2 < 10) {
            n2 = 10;
        }
        Dimension dimension2 = this.controller.getCanvasL().getSize();
        int n3 = dimension2.width;
        int n4 = dimension2.height;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        int n5 = dimension3.width;
        int n6 = dimension3.height;
        Dimension dimension4 = this.getSize();
        int n7 = dimension4.width;
        int n8 = dimension4.height;
        int n9 = n - dimension2.width;
        int n10 = n2 - dimension2.height;
        if (n7 + n9 > n5) {
            n9 = n5 - n7;
        }
        if (n8 + n10 > n6) {
            n10 = n6 - n8;
        }
        this.setSize(n7 + n9, n8 + n10);
        this.setVisible(true);
        this.controller.refresh();
        return new Dimension(n3 + n9, n4 + n10);
    }

    public void pdbjExecute(int n, String string) {
    }

    public void initializeStereo() {
    }

    public boolean isNewt() {
        return false;
    }

    public ViewerController getViewerController() {
        return this.controller;
    }

    public MouseBehavior getMouseBehavior() {
        return this.mouseBehavior;
    }

    public void loadLocalFile(FileType fileType) {
    }

    public void loadRemoteFile(FileType fileType) {
    }

    public void loadRemoteFile(UrlDialog urlDialog) {
    }

    public void loadByPDBID() {
    }

    public void loadByEFsiteID() {
    }

    public void loadHistory(FileType fileType, FileLocator fileLocator) {
    }

    public void addFileHistory(FileType fileType, FileLocator fileLocator) {
    }

    public void saveFile(FileType fileType) {
    }

    public void showInformation() {
    }

    public void showAnimationFrame() {
    }

    public void showAboutDialog() {
    }

    public void openManual() {
    }

    public void rotateStereo() {
    }

    public void handleRecoverableException(RecoverableException recoverableException) {
        this.showWarning((Exception)recoverableException);
    }

    public void handleFatalException(FatalException fatalException) {
        this.showErrorAndExit((Exception)fatalException);
    }

    public void startCommand(String string, CommandType commandType) {
        this.startCommand(this.executor.createTokenizer(string), commandType);
    }

    public void startCommand(CommandTokenizer commandTokenizer, CommandType commandType) {
        try {
            if (commandTokenizer != null) {
                this.executor.execute(commandTokenizer);
            }
        }
        catch (RecoverableException recoverableException) {
            this.handleRecoverableException(recoverableException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleFatalException(ExceptionUtil.handleOutOfMemoryError((OutOfMemoryError)outOfMemoryError));
        }
        catch (Throwable throwable) {
            this.handleFatalException(ExceptionUtil.handleThrowable((Throwable)throwable));
        }
        if (commandType.action == 1) {
            this.controller.startRenderer();
        }
        this.endCommand();
    }

    public void endCommand() {
        this.updateMenu();
        this.commandArea.setActive(true);
        this.commandQueue.setActive(true);
    }

    public boolean menuActive() {
        return true;
    }

    public void commandKeyTyped() {
    }

    public void focusMoved() {
    }

    public void receiveMousePick(PickResult pickResult) {
    }

    protected abstract void updateMenu();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadScript(File file) {
        this.controller.stopRenderer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2 = string.trim();
                    if (string.startsWith("#")) continue;
                    this.executeSingleCommand(string2);
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            this.showWarning(iOException);
        }
        finally {
            this.controller.startRenderer();
        }
    }

    protected void savePng(File file) {
        try {
            BufferedImage bufferedImage = this.controller.getImage();
            ImageFileWriter.writePNG((File)file, (BufferedImage)bufferedImage);
        }
        catch (RecoverableException recoverableException) {
            this.showWarning((Exception)((Object)recoverableException));
        }
    }

    protected void saveJpeg(File file) {
        try {
            BufferedImage bufferedImage = this.controller.getImage();
            ImageFileWriter.writeJPEG((File)file, (BufferedImage)bufferedImage, (float)0.75f);
        }
        catch (RecoverableException recoverableException) {
            this.showWarning((Exception)((Object)recoverableException));
        }
    }

    protected void showWarning(Exception exception) {
        JOptionPane.showMessageDialog(this, exception.getMessage(), "Warning", 2);
    }

    protected void showErrorAndExit(Exception exception) {
        JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
        this.exit();
    }

    protected void displayProteinWireframe() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("protein", this.context, false));
        this.controller.wireframe(0.0f);
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayProteinBackbone() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("protein", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillOff();
        this.controller.backbone(0.3f);
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayProteinStick() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("protein", this.context, false));
        this.controller.wireframe(0.2f);
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayProteinSpacefill() {
        this.controller.stopRenderer();
        this.controller.select(this.parser.parse("protein", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillVdW();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayProteinBallStick() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("protein", this.context, false));
        this.controller.wireframe(0.2f);
        this.controller.spacefill(0.5f);
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayProteinRibbon() {
        this.controller.stopRenderer();
        this.controller.select(this.parser.parse("protein", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbon();
        this.controller.startRenderer();
    }

    protected void displayProteinCartoon() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("protein", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.cartoon();
        this.controller.startRenderer();
    }

    protected void displayLigandWireframe() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("LIG", this.context, false));
        this.controller.wireframe(0.0f);
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandStick() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("LIG", this.context, false));
        this.controller.wireframe(0.2f);
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandSpacefill() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("LIG", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillVdW();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandBallStick() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("LIG", this.context, false));
        this.controller.wireframe(0.2f);
        this.controller.spacefill(0.5f);
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandNeighborWireframe() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("within(5.0,LIG) & protein & sidechain", this.context, false));
        this.controller.wireframe(0.0f);
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandNeighborStick() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("within(5.0,LIG) & protein & sidechain", this.context, false));
        this.controller.wireframe(0.2f);
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandNeighborSpacefill() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("within(5.0,LIG) & protein & sidechain", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillVdW();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandNeighborBallStick() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("within(5.0,LIG) & protein & sidechain", this.context, false));
        this.controller.wireframe(0.2f);
        this.controller.spacefill(0.5f);
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandNeighborOff() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(0);
        this.controller.select(this.parser.parse("within(5.0,LIG) & protein & sidechain", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displayLigandHbondDashedLine() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(1);
        this.controller.select(this.parser.parse("LIG", this.context, false));
        this.controller.hBond(0.0f);
        this.controller.startRenderer();
    }

    protected void displayLigandHbondStick() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(1);
        this.controller.select(this.parser.parse("LIG", this.context, false));
        this.controller.hBond(0.2f);
        this.controller.startRenderer();
    }

    protected void displayLigandHbondOff() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(1);
        this.controller.select(this.parser.parse("LIG", this.context, false));
        this.controller.hBondOff();
        this.controller.startRenderer();
    }

    protected void displaySolventWireframe() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(1);
        this.controller.select(this.parser.parse("SOL", this.context, false));
        this.controller.wireframe(0.0f);
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void displaySolventOff() {
        this.controller.stopRenderer();
        this.controller.getSelectionStatus().setBondMode(1);
        this.controller.select(this.parser.parse("SOL", this.context, false));
        this.controller.wireframeOff();
        this.controller.spacefillOff();
        this.controller.backboneOff();
        this.controller.ribbonOff();
        this.controller.startRenderer();
    }

    protected void processDssp(PlotDataXpm plotDataXpm) {
        float f = plotDataXpm.getXaxisScale();
        int n = this.moleculeFile.numMolecules();
        int n2 = 0;
        block0: for (int i = 0; i < plotDataXpm.getNumX(); ++i) {
            float f2 = plotDataXpm.getX(i) * f;
            while (n2 < n) {
                MoleculeTraj moleculeTraj = this.moleculeFile.getMoleculeTraj(n2);
                float f3 = moleculeTraj.getTime();
                if (f3 < f2) {
                    this.clearStructure(moleculeTraj);
                    ++n2;
                    continue;
                }
                if (f3 != f2) continue block0;
                this.assignStructure(moleculeTraj, plotDataXpm, i);
                ++n2;
                continue block0;
            }
        }
        while (n2 < n) {
            MoleculeTraj moleculeTraj = this.moleculeFile.getMoleculeTraj(n2);
            this.clearStructure(moleculeTraj);
            ++n2;
        }
        this.controller.select(this.parser.parse("protein", this.context, false));
        ColorExpr colorExpr = new ColorExpr();
        colorExpr.setTarget(5);
        colorExpr.setScheme(11);
        this.controller.setColor(colorExpr);
        this.controller.cartoon();
        this.controller.refresh();
    }

    private void assignStructure(MoleculeTraj moleculeTraj, PlotDataXpm plotDataXpm, int n) {
        this.clearStructure(moleculeTraj);
        if (plotDataXpm.getNumY() == 0) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < moleculeTraj.numChains(); ++i) {
            Chain chain = moleculeTraj.getChain(i);
            for (int j = 0; j < chain.numResidues(); ++j) {
                Residue residue = chain.getResidue(j);
                this.assignStructure(residue, plotDataXpm.getValue(n, n2++));
                if (n2 != plotDataXpm.getNumY()) continue;
                return;
            }
        }
    }

    private void assignStructure(Residue residue, PointValue pointValue) {
        char c = pointValue.getElement();
        if (c == '~') {
            residue.setStructure(0);
            residue.setStructureGromacs(1);
        } else if (c == 'E') {
            residue.setStructure(2);
            residue.setStructureGromacs(2);
        } else if (c == 'B') {
            residue.setStructure(0);
            residue.setStructureGromacs(3);
        } else if (c == 'S') {
            residue.setStructure(3);
            residue.setStructureGromacs(4);
        } else if (c == 'T') {
            residue.setStructure(3);
            residue.setStructureGromacs(5);
        } else if (c == 'H') {
            residue.setStructure(1);
            residue.setStructureGromacs(6);
        } else if (c == 'I') {
            residue.setStructure(1);
            residue.setStructureGromacs(7);
        } else if (c == 'G') {
            residue.setStructure(1);
            residue.setStructureGromacs(8);
        } else {
            residue.setStructure(0);
            residue.setStructureGromacs(0);
        }
        ColorManager colorManager = this.controller.getColorManager();
        residue.setColorIndexGromacs(colorManager.getIndex(pointValue.getColor()));
    }

    private void clearStructure(MoleculeTraj moleculeTraj) {
        moleculeTraj.setStructure(3);
        moleculeTraj.setRefreshResidue(true);
        for (int i = 0; i < moleculeTraj.numChains(); ++i) {
            Chain chain = moleculeTraj.getChain(i);
            for (int j = 0; j < chain.numResidues(); ++j) {
                Residue residue = chain.getResidue(j);
                residue.setStructure(0);
                residue.setStructureGromacs(0);
                residue.setColorIndexGromacs(-1);
            }
        }
    }

    protected void processHbond(File file, PlotDataXpm plotDataXpm) {
        int[][] nArray = this.readHbondIndex(file);
        if (nArray.length != plotDataXpm.getNumY()) {
            throw new CustomException("different number of H-bonds between index file and map file.");
        }
        HashMap<Integer, Atom> hashMap = new HashMap<Integer, Atom>();
        HashMap<Integer, Residue> hashMap2 = new HashMap<Integer, Residue>();
        this.createMap(hashMap, hashMap2);
        float f = plotDataXpm.getXaxisScale();
        int n = this.moleculeFile.numMolecules();
        int n2 = 0;
        block0: for (int i = 0; i < plotDataXpm.getNumX(); ++i) {
            float f2 = plotDataXpm.getX(i) * f;
            while (n2 < n) {
                MoleculeTraj moleculeTraj = this.moleculeFile.getMoleculeTraj(n2);
                float f3 = moleculeTraj.getTime();
                if (f3 < f2) {
                    this.clearHbond(moleculeTraj);
                    ++n2;
                    continue;
                }
                if (f3 != f2) continue block0;
                this.createHbond(moleculeTraj, hashMap, hashMap2, nArray, plotDataXpm, i);
                ++n2;
                continue block0;
            }
        }
        while (n2 < n) {
            MoleculeTraj moleculeTraj = this.moleculeFile.getMoleculeTraj(n2);
            this.clearHbond(moleculeTraj);
            ++n2;
        }
        this.controller.select(true);
        this.controller.hBond(0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[][] readHbondIndex(File file) {
        String[] stringArray;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            object = new BufferedReader(new FileReader(file));
            try {
                boolean bl = false;
                stringArray = null;
                while ((stringArray = ((BufferedReader)object).readLine()) != null) {
                    if (bl) {
                        arrayList.add(stringArray.trim());
                    }
                    if (stringArray.startsWith("[ hbonds_")) {
                        bl = true;
                        continue;
                    }
                    if (!stringArray.startsWith("[")) continue;
                    bl = false;
                }
            }
            finally {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            throw new CustomException(iOException);
        }
        object = new int[arrayList.size()][2];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray = ((String)arrayList.get(i)).split("\\s+");
            object[i][0] = Integer.parseInt(stringArray[0]);
            object[i][1] = Integer.parseInt(stringArray[2]);
        }
        return object;
    }

    private void createMap(Map<Integer, Atom> map, Map<Integer, Residue> map2) {
        MoleculeTraj moleculeTraj = this.moleculeFile.getMoleculeTraj(0);
        for (int i = 0; i < moleculeTraj.numChains(); ++i) {
            Chain chain = moleculeTraj.getChain(i);
            for (int j = 0; j < chain.numResidues(); ++j) {
                Residue residue = chain.getResidue(j);
                for (int k = 0; k < residue.numAtoms(); ++k) {
                    Atom atom = residue.getAtom(k);
                    if (map.containsKey(atom.getId())) continue;
                    map.put(atom.getId(), atom);
                    map2.put(atom.getId(), residue);
                }
            }
        }
    }

    private void clearHbond(MoleculeTraj moleculeTraj) {
        moleculeTraj.getHBonds().clear();
        moleculeTraj.setBuiltHBond(true);
        for (int i = 0; i < moleculeTraj.numChains(); ++i) {
            Chain chain = moleculeTraj.getChain(i);
            for (int j = 0; j < chain.numResidues(); ++j) {
                Residue residue = chain.getResidue(j);
                residue.setHBondIndex(-1);
            }
        }
    }

    private void createHbond(MoleculeTraj moleculeTraj, Map<Integer, Atom> map, Map<Integer, Residue> map2, int[][] nArray, PlotDataXpm plotDataXpm, int n) {
        this.clearHbond(moleculeTraj);
        int n2 = 0;
        Residue residue = null;
        for (int[] nArray2 : nArray) {
            if (plotDataXpm.getValue(n, n2++).getElement() != 'o') continue;
            Atom atom = map.get(nArray2[0]);
            Atom atom2 = map.get(nArray2[1]);
            if (atom == null || atom2 == null) {
                throw new CustomException("inconsistent atom ID at H-bond: " + nArray2[0] + " - " + nArray2[1]);
            }
            Residue residue2 = map2.get(nArray2[0]);
            Residue residue3 = map2.get(nArray2[1]);
            HBond hBond = new HBond();
            hBond.setSrcCA(residue2.getProteinCA());
            hBond.setDstCA(residue3.getProteinCA());
            hBond.setSrcAtom(atom);
            hBond.setDstAtom(atom2);
            if (residue == null || residue != residue2) {
                residue2.setHBondIndex(moleculeTraj.numHBonds());
            }
            moleculeTraj.addHBond(hBond);
            residue = residue2;
        }
    }

    static {
        GLProfile.initSingleton();
    }
}

