/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.lib.xdrfile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.riken.lib.xdrfile.XdrfileException;
import jp.riken.lib.xdrfile.XdrfileFrame;

public class Xdrfile {
    private BufferedInputStream inputStream;
    private ByteBuffer buffer = ByteBuffer.allocate(8192);
    private static final int BUFFER_SIZE = 8192;
    private int[] buf1;
    private int buf1size;
    private byte[] buf2;
    private int buf2size;
    private long[] buf3;
    private static final int[] MAGICINTS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 10, 12, 16, 20, 25, 32, 40, 50, 64, 80, 101, 128, 161, 203, 256, 322, 406, 512, 645, 812, 1024, 1290, 1625, 2048, 2580, 3250, 4096, 5060, 6501, 8192, 10321, 13003, 16384, 20642, 26007, 32768, 41285, 52015, 65536, 82570, 104031, 131072, 165140, 208063, 262144, 330280, 416127, 524287, 660561, 832255, 0x100000, 1321122, 1664510, 0x200000, 2642245, 3329021, 0x400000, 5284491, 6658042, 0x7FFFFF, 10568983, 13316085, 0x1000000};
    private static final int FIRSTIDX = 9;

    public Xdrfile() {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buf3 = new long[3];
    }

    public void openRead(File file) throws XdrfileException {
        try {
            this.inputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XdrfileException(1, (Throwable)fileNotFoundException);
        }
    }

    public void close() throws XdrfileException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                throw new XdrfileException(2, (Throwable)iOException);
            }
        }
    }

    public byte readByte() throws XdrfileException {
        try {
            int n = this.inputStream.read(this.buffer.array(), 0, 1);
            if (n < 1) {
                throw new XdrfileException(5);
            }
            return this.buffer.get(0);
        }
        catch (IOException iOException) {
            throw new XdrfileException(2, (Throwable)iOException);
        }
    }

    public void readByte(byte[] byArray, int n) throws XdrfileException {
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = this.inputStream.read(this.buffer.array(), 0, 1);
                if (n2 < 1) {
                    throw new XdrfileException(5);
                }
                byArray[i] = this.buffer.get(0);
            }
        }
        catch (IOException iOException) {
            throw new XdrfileException(2, (Throwable)iOException);
        }
    }

    public int readInt() throws XdrfileException {
        try {
            int n = this.inputStream.read(this.buffer.array(), 0, 4);
            if (n < 4) {
                throw new XdrfileException(5);
            }
            return this.buffer.getInt(0);
        }
        catch (IOException iOException) {
            throw new XdrfileException(2, (Throwable)iOException);
        }
    }

    public void readInt(int[] nArray, int n) throws XdrfileException {
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = this.inputStream.read(this.buffer.array(), 0, 4);
                if (n2 < 4) {
                    throw new XdrfileException(5);
                }
                nArray[i] = this.buffer.getInt(0);
            }
        }
        catch (IOException iOException) {
            throw new XdrfileException(2, (Throwable)iOException);
        }
    }

    public float readFloat() throws XdrfileException {
        try {
            int n = this.inputStream.read(this.buffer.array(), 0, 4);
            if (n < 4) {
                throw new XdrfileException(5);
            }
            return this.buffer.getFloat(0);
        }
        catch (IOException iOException) {
            throw new XdrfileException(2, (Throwable)iOException);
        }
    }

    public void readFloat(float[] fArray, int n) throws XdrfileException {
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = this.inputStream.read(this.buffer.array(), 0, 4);
                if (n2 < 4) {
                    throw new XdrfileException(5);
                }
                fArray[i] = this.buffer.getFloat(0);
            }
        }
        catch (IOException iOException) {
            throw new XdrfileException(2, (Throwable)iOException);
        }
    }

    public void decompressCoordFloat(XdrfileFrame xdrfileFrame) throws XdrfileException {
        int n = this.readInt();
        if (xdrfileFrame.getNatoms() < n) {
            throw new XdrfileException(4);
        }
        int n2 = n * 3;
        if (n2 > this.buf1size) {
            this.buf1size = n2;
            this.buf1 = new int[this.buf1size];
            this.buf2size = (int)((double)n2 * 1.2 * 4.0);
            this.buf2 = new byte[this.buf2size];
        }
        if (xdrfileFrame.getNatoms() <= 9) {
            this.readFloat(xdrfileFrame.getX(), n2);
            return;
        }
        xdrfileFrame.setPrec(this.readFloat());
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        long[] lArray = new long[3];
        long[] lArray2 = new long[3];
        int[] nArray3 = new int[3];
        int n3 = 0;
        nArray3[0] = 0;
        nArray3[1] = 0;
        nArray3[2] = 0;
        this.buf3[2] = 0L;
        this.buf3[1] = 0L;
        this.buf3[0] = 0L;
        this.readInt(nArray, 3);
        this.readInt(nArray2, 3);
        lArray[0] = (long)nArray2[0] - (long)nArray[0] + 1L;
        lArray[1] = (long)nArray2[1] - (long)nArray[1] + 1L;
        lArray[2] = (long)nArray2[2] - (long)nArray[2] + 1L;
        if ((lArray[0] | lArray[1] | lArray[2]) > 0xFFFFFFL) {
            nArray3[0] = this.sizeOfInt(lArray[0]);
            nArray3[1] = this.sizeOfInt(lArray[1]);
            nArray3[2] = this.sizeOfInt(lArray[2]);
            n3 = 0;
        } else {
            n3 = this.sizeOfInts(3, lArray);
        }
        int n4 = this.readInt();
        int n5 = n4 + 8;
        n5 = n4 - 1;
        n5 = 9 > n5 ? 9 : n5;
        int n6 = MAGICINTS[n5] / 2;
        int n7 = MAGICINTS[n4] / 2;
        lArray2[1] = lArray2[2] = (long)MAGICINTS[n4];
        lArray2[0] = lArray2[2];
        this.buf3[0] = this.readInt();
        this.readOpaque((int)this.buf3[0]);
        this.buf3[2] = 0L;
        this.buf3[1] = 0L;
        this.buf3[0] = 0L;
        float[] fArray = xdrfileFrame.getX();
        int n8 = 0;
        float f = 1.0f / xdrfileFrame.getPrec();
        int n9 = 0;
        int n10 = 0;
        int[] nArray4 = new int[3];
        while (n10 < n) {
            int n11 = n10 * 3;
            int n12 = n10 * 3 + 1;
            int n13 = n10 * 3 + 2;
            if (n3 == 0) {
                this.buf1[n11] = this.decodeBits(nArray3[0]);
                this.buf1[n12] = this.decodeBits(nArray3[1]);
                this.buf1[n13] = this.decodeBits(nArray3[2]);
            } else {
                this.decodeInts(3, n3, lArray, n11);
            }
            ++n10;
            int n14 = n11;
            this.buf1[n14] = this.buf1[n14] + nArray[0];
            int n15 = n12;
            this.buf1[n15] = this.buf1[n15] + nArray[1];
            int n16 = n13;
            this.buf1[n16] = this.buf1[n16] + nArray[2];
            nArray4[0] = this.buf1[n11];
            nArray4[1] = this.buf1[n12];
            nArray4[2] = this.buf1[n13];
            int n17 = this.decodeBits(1);
            int n18 = 0;
            if (n17 == 1) {
                n9 = this.decodeBits(5);
                n18 = n9 % 3;
                n9 -= n18;
                --n18;
            }
            if (n9 > 0) {
                n11 += 3;
                n12 += 3;
                n13 += 3;
                for (int i = 0; i < n9; i += 3) {
                    this.decodeInts(3, n4, lArray2, n11);
                    ++n10;
                    int n19 = n11;
                    this.buf1[n19] = this.buf1[n19] + (nArray4[0] - n7);
                    int n20 = n12;
                    this.buf1[n20] = this.buf1[n20] + (nArray4[1] - n7);
                    int n21 = n13;
                    this.buf1[n21] = this.buf1[n21] + (nArray4[2] - n7);
                    if (i == 0) {
                        n5 = this.buf1[n11];
                        this.buf1[n11] = nArray4[0];
                        nArray4[0] = n5;
                        n5 = this.buf1[n12];
                        this.buf1[n12] = nArray4[1];
                        nArray4[1] = n5;
                        n5 = this.buf1[n13];
                        this.buf1[n13] = nArray4[2];
                        nArray4[2] = n5;
                        fArray[n8++] = (float)nArray4[0] * f;
                        fArray[n8++] = (float)nArray4[1] * f;
                        fArray[n8++] = (float)nArray4[2] * f;
                    } else {
                        nArray4[0] = this.buf1[n11];
                        nArray4[1] = this.buf1[n12];
                        nArray4[2] = this.buf1[n13];
                    }
                    fArray[n8++] = (float)this.buf1[n11] * f;
                    fArray[n8++] = (float)this.buf1[n12] * f;
                    fArray[n8++] = (float)this.buf1[n13] * f;
                }
            } else {
                fArray[n8++] = (float)this.buf1[n11] * f;
                fArray[n8++] = (float)this.buf1[n12] * f;
                fArray[n8++] = (float)this.buf1[n13] * f;
            }
            n4 += n18;
            if (n18 < 0) {
                n7 = n6;
                n6 = n4 > 9 ? MAGICINTS[n4 - 1] / 2 : 0;
            } else if (n18 > 0) {
                n6 = n7;
                n7 = MAGICINTS[n4] / 2;
            }
            lArray2[1] = lArray2[2] = (long)MAGICINTS[n4];
            lArray2[0] = lArray2[2];
        }
    }

    private int sizeOfInt(long l) {
        int n;
        long l2 = 1L;
        for (n = 0; l >= l2 && n < 32; ++n, l2 <<= 1) {
        }
        return n;
    }

    private int sizeOfInts(int n, long[] lArray) {
        int n2;
        int[] nArray = new int[32];
        nArray[0] = 1;
        int n3 = 1;
        int n4 = 0;
        long l = 0L;
        for (n2 = 0; n2 < n; ++n2) {
            l = 0L;
            for (n4 = 0; n4 < n3; ++n4) {
                l = (long)nArray[n4] * lArray[n2] + l;
                nArray[n4] = (int)(l & 0xFFL);
                l >>= 8;
            }
            while (l != 0L) {
                nArray[n4++] = (int)(l & 0xFFL);
                l >>= 8;
            }
            n3 = n4;
        }
        n2 = 0;
        --n3;
        for (int i = 1; nArray[n3] >= i; i *= 2) {
            ++n2;
        }
        return n2 + n3 * 8;
    }

    private void readOpaque(int n) {
        if (n == 0) {
            return;
        }
        byte[] byArray = new byte[4];
        int n2 = n % 4;
        if (n2 > 0) {
            n2 = 4 - n2;
        }
        this.readByte(this.buf2, n);
        if (n2 > 0) {
            this.readByte(byArray, n2);
        }
    }

    private int decodeBits(int n) {
        int n2 = (int)this.buf3[0];
        long l = this.buf3[1];
        long l2 = this.buf3[2];
        int n3 = (1 << n) - 1;
        int n4 = 0;
        while (n >= 8) {
            l2 = l2 << 8 | (long)this.asUnsignedByte(n2++);
            n4 = (int)((long)n4 | (l2 &= 0xFFFFFFFFFFFFFFFFL) >> (int)l << n - 8);
            n -= 8;
        }
        if (n > 0) {
            if (l < (long)n) {
                l += 8L;
                l2 = l2 << 8 | (long)this.asUnsignedByte(n2++);
                l2 &= 0xFFFFFFFFFFFFFFFFL;
            }
            n4 = (int)((long)n4 | l2 >> (int)(l -= (long)n) & (long)((1 << n) - 1));
        }
        this.buf3[0] = n2;
        this.buf3[1] = l;
        this.buf3[2] = l2;
        return n4 &= n3;
    }

    private int asUnsignedByte(int n) {
        return this.buf2[n] >= 0 ? this.buf2[n] : this.buf2[n] + 256;
    }

    private void decodeInts(int n, int n2, long[] lArray, int n3) {
        int[] nArray = new int[32];
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        int n4 = 0;
        while (n2 > 8) {
            nArray[n4++] = this.decodeBits(8);
            n2 -= 8;
        }
        if (n2 > 0) {
            nArray[n4++] = this.decodeBits(n2);
        }
        for (int i = n - 1; i > 0; --i) {
            int n5 = 0;
            for (int j = n4 - 1; j >= 0; --j) {
                int n6;
                n5 = n5 << 8 | nArray[j];
                nArray[j] = n6 = (int)((long)n5 / lArray[i]);
                n5 = (int)((long)n5 - (long)n6 * lArray[i]);
            }
            this.buf1[n3 + i] = n5;
        }
        this.buf1[n3] = nArray[0] | nArray[1] << 8 | nArray[2] << 16 | nArray[3] << 24;
    }
}

