/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.lib.xdrfile;

import java.io.File;
import jp.riken.lib.xdrfile.Xdrfile;
import jp.riken.lib.xdrfile.XdrfileException;
import jp.riken.lib.xdrfile.XdrfileFrame;

public class XdrfileXtc {
    public static final int MAGIC = 1995;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readXtcNatoms(File file) throws XdrfileException {
        Xdrfile xdrfile = new Xdrfile();
        XdrfileFrame xdrfileFrame = new XdrfileFrame();
        try {
            xdrfile.openRead(file);
            XdrfileXtc.readXtcHeader(xdrfile, xdrfileFrame);
            int n = xdrfileFrame.getNatoms();
            return n;
        }
        finally {
            xdrfile.close();
        }
    }

    public static boolean readXtcHeader(Xdrfile xdrfile, XdrfileFrame xdrfileFrame) throws XdrfileException {
        int n = 0;
        try {
            n = xdrfile.readInt();
        }
        catch (XdrfileException xdrfileException) {
            if (xdrfileException.getCode() == 5) {
                return false;
            }
            throw xdrfileException;
        }
        if (n != 1995) {
            throw new XdrfileException(3);
        }
        xdrfileFrame.setNatoms(xdrfile.readInt());
        xdrfileFrame.setStep(xdrfile.readInt());
        xdrfileFrame.setTime(xdrfile.readFloat());
        return true;
    }

    public static void readXtcCoord(Xdrfile xdrfile, XdrfileFrame xdrfileFrame) throws XdrfileException {
        xdrfile.readFloat(xdrfileFrame.getBox(), 9);
        xdrfile.decompressCoordFloat(xdrfileFrame);
    }

    public static boolean readXtc(Xdrfile xdrfile, XdrfileFrame xdrfileFrame) throws XdrfileException {
        if (XdrfileXtc.readXtcHeader(xdrfile, xdrfileFrame)) {
            xdrfileFrame.setupX();
            XdrfileXtc.readXtcCoord(xdrfile, xdrfileFrame);
            return true;
        }
        return false;
    }
}

