/*
 * Copyright (c) 2013-2014, RIKEN, Japan
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is a derived work of GROMACS xdrfile project version 1.1.1.
 * http://www.gromacs.org/Downloads
 * 
 * The original code is written in C and licensed as below.
 */

/* -*- mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- 
 *
 * $Id$
 *
 * Copyright (c) Erik Lindahl, David van der Spoel 2003,2004.
 * Coordinate compression (c) by Frans van Hoesel. 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 */
package jp.riken.lib.xdrfile;

public class XdrfileException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    public static final int CANNOT_OPEN = 1;
    public static final int IO_ERROR = 2;
    public static final int WRONG_MAGIC = 3;
    public static final int INCONSISTENT_DATA = 4;
    public static final int EOF = 5;

    private int code;

    public XdrfileException(int code) {
        this.code = code;
    }

    public XdrfileException(int code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    public int getCode() {
        return code;
    }
}
