/*
 * Copyright (c) 2013-2014, RIKEN, Japan
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is a derived work of GROMACS xdrfile project version 1.1.1.
 * http://www.gromacs.org/Downloads
 * 
 * The original code is written in C and licensed as below.
 */

/* -*- mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- 
 *
 * $Id$
 *
 * Copyright (c) Erik Lindahl, David van der Spoel 2003,2004.
 * Coordinate compression (c) by Frans van Hoesel. 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 */
package jp.riken.lib.xdrfile;

public class XdrfileFrame {

    private int natoms;
    private int step;
    private float time;
    private float[] box;
    private float[] x;
    private float prec;

    public XdrfileFrame() {
        box = new float[9];
    }

    public int getNatoms() {
        return natoms;
    }

    public void setNatoms(int natoms) {
        this.natoms = natoms;
    }

    public int getStep() {
        return step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public float getTime() {
        return time;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public float[] getBox() {
        return box;
    }

    public float[] getX() {
        return x;
    }

    public float getPrec() {
        return prec;
    }

    public void setPrec(float prec) {
        this.prec = prec;
    }

    public void setupX() {
        if (x == null) {
            x = new float[natoms * 3];
        }
    }
}
