/*
 * Copyright (c) 2013-2014, RIKEN, Japan
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is a derived work of GROMACS xdrfile project version 1.1.1.
 * http://www.gromacs.org/Downloads
 * 
 * The original code is written in C and licensed as below.
 */

/* -*- mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- 
 *
 * $Id$
 *
 * Copyright (c) Erik Lindahl, David van der Spoel 2003,2004.
 * Coordinate compression (c) by Frans van Hoesel. 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 */
package jp.riken.lib.xdrfile;

import java.io.File;

public class XdrfileXtc {

    public static final int MAGIC = 1995;

    public static int readXtcNatoms(File file) throws XdrfileException {
        Xdrfile xd = new Xdrfile();
        XdrfileFrame frame = new XdrfileFrame();
        try {
            xd.openRead(file);
            readXtcHeader(xd, frame);
            return frame.getNatoms();
        } finally {
            xd.close();
        }
    }

    public static boolean readXtcHeader(Xdrfile xd, XdrfileFrame frame)
            throws XdrfileException {
        int magic = 0;
        try {
            magic = xd.readInt();
        } catch (XdrfileException e) {
            if (e.getCode() == XdrfileException.EOF) {
                return false;
            } else {
                throw e;
            }
        }
        if (magic != MAGIC) {
            throw new XdrfileException(XdrfileException.WRONG_MAGIC);
        }
        frame.setNatoms(xd.readInt());
        frame.setStep(xd.readInt());
        frame.setTime(xd.readFloat());
        return true;
    }

    public static void readXtcCoord(Xdrfile xd, XdrfileFrame frame)
            throws XdrfileException {
        xd.readFloat(frame.getBox(), 9);
        xd.decompressCoordFloat(frame);
    }

    public static boolean readXtc(Xdrfile xd, XdrfileFrame frame)
            throws XdrfileException {
        if (readXtcHeader(xd, frame)) {
            frame.setupX();
            readXtcCoord(xd, frame);
            return true;
        }
        return false;
    }
}
