/*
 * Modified at March 2014.
 * RIKEN, Japan
 */

/*
* Binary and Source Code License Agreement for jV Version 4.3.1
* Copyright (c) 2003-2013, Protein Data Bank Japan
* All rights reserved.
* 
* The software, jV, and the associated documentation files (the 
* "Software") were developed by Drs. Kengo Kinoshita and Haruki Nakamura 
* in Protein Data Bank Japan at Institute for Protein Research, Osaka 
* University (the "Contributors"), which is supported by grant-in-aid 
* from National Bioscience Database Center, Japan Science and Technology
* Agancy (JST-NBDC) and Osaka University.
* 
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions 
* are met:
* 
* *  Redistributions of the source code for the Software must retain the
*    above copyright notice, this list of conditions and the following
*    disclaimer.
* 
* *  Redistributions in the binary form for the Software must reproduce
*    the above copyright notice, this list of conditions and the following
*    disclaimer in the documentation and/or other materials provided with
*    the distribution.
* 
* *  Neither the name of the Institute for Protein Research, Osaka University
*    nor the names of the Contributors may be used to endorse or promote
*    products derived from this software without specific prior written
*    permission.
* 
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
*    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
*    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
*    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
*    ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
*    POSSIBILITY OF SUCH DAMAGE.
*/
package org.pdbj.viewer.images;

// 20040514 bond cap radius

/**
 * Image of atoms.
 */
public class AtomImage extends ImageComponentImpl
{
    public static final int MODEL_SPACEFILL = 1;

    private float _radius;
    private float _capRadius;

    /**
     * Sets the radius of the image.
     */
    public void setRadius(float radius)
    {
        _radius = radius;
    }

    /**
     * Returns the radius of the image.
     */
    public float getRadius()
    {
        return _radius;
    }

    /**
     * Sets the radius of the bond cap.
     */
    public void setCapRadius(float capRadius)
    {
        _capRadius = capRadius;
    }

    /**
     * Returns the radius of the bond cap.
     */
    public float getCapRadius()
    {
        return _capRadius;
    }

    /**
     * Default constructor.
     */
    public AtomImage()
    {
        this.clear();
    }

    /**
     * Called when image is cleared.
     */
    protected void clear()
    {
        _radius = 0;
    }
}

