/*
 * Modified at March 2014.
 * RIKEN, Japan
 */

/*
* Binary and Source Code License Agreement for jV Version 4.3.1
* Copyright (c) 2003-2013, Protein Data Bank Japan
* All rights reserved.
* 
* The software, jV, and the associated documentation files (the 
* "Software") were developed by Drs. Kengo Kinoshita and Haruki Nakamura 
* in Protein Data Bank Japan at Institute for Protein Research, Osaka 
* University (the "Contributors"), which is supported by grant-in-aid 
* from National Bioscience Database Center, Japan Science and Technology
* Agancy (JST-NBDC) and Osaka University.
* 
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions 
* are met:
* 
* *  Redistributions of the source code for the Software must retain the
*    above copyright notice, this list of conditions and the following
*    disclaimer.
* 
* *  Redistributions in the binary form for the Software must reproduce
*    the above copyright notice, this list of conditions and the following
*    disclaimer in the documentation and/or other materials provided with
*    the distribution.
* 
* *  Neither the name of the Institute for Protein Research, Osaka University
*    nor the names of the Contributors may be used to endorse or promote
*    products derived from this software without specific prior written
*    permission.
* 
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
*    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
*    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
*    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
*    ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
*    POSSIBILITY OF SUCH DAMAGE.
*/
package org.pdbj.viewer.images;

/**
 * Component of molecule images.
 */
public abstract class ImageComponent
{
    public static final int MODEL_NONE = 0;

    private boolean _displayed;

    /**
     * Sets the rendering model.
     */
    public abstract void setModel(int model);

    /**
     * Returns the rendering model.
     */
    public abstract int getModel();

    /**
     * Sets the color index in ColorManager object.
     */
    public abstract void setColorIndex(int colorIndex);

    /**
     * Returns the color index in ColorManager object.
     */
    public abstract int getColorIndex();

    /**
     * Sets whether this is displayed.
     */
    public void setDisplayed(boolean displayed)
    {
        _displayed = displayed;
    }

    /**
     * Tests whether this is displayed.
     */
    public boolean isDisplayed()
    {
        return _displayed;
    }

    /**
     * Default constructor.
     */
    public ImageComponent()
    {
        _displayed = true;
    }

    /**
     * Called when image is cleared.
     */
    protected void clear()
    {
    }
}

