/*
* Binary and Source Code License Agreement for jV Version 4.3.1
* Copyright (c) 2003-2013, Protein Data Bank Japan
* All rights reserved.
* 
* The software, jV, and the associated documentation files (the 
* "Software") were developed by Drs. Kengo Kinoshita and Haruki Nakamura 
* in Protein Data Bank Japan at Institute for Protein Research, Osaka 
* University (the "Contributors"), which is supported by grant-in-aid 
* from National Bioscience Database Center, Japan Science and Technology
* Agancy (JST-NBDC) and Osaka University.
* 
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions 
* are met:
* 
* *  Redistributions of the source code for the Software must retain the
*    above copyright notice, this list of conditions and the following
*    disclaimer.
* 
* *  Redistributions in the binary form for the Software must reproduce
*    the above copyright notice, this list of conditions and the following
*    disclaimer in the documentation and/or other materials provided with
*    the distribution.
* 
* *  Neither the name of the Institute for Protein Research, Osaka University
*    nor the names of the Contributors may be used to endorse or promote
*    products derived from this software without specific prior written
*    permission.
* 
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
*    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
*    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
*    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
*    ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
*    POSSIBILITY OF SUCH DAMAGE.
*/
package org.pdbj.viewer.images;

import org.pdbj.viewer.utils.*;

/**
 * Represents polygon image.
 */
public class PolygonImage
{
    private Matrix4f _transform;

    private boolean _initialized;
    private boolean _refresh;

    private int _pointListIndex;
    private int _lineListIndex;
    private int _triangleListIndex;
    private int _quadListIndex;
    private int _polylineListIndex;

    private int _triangleBackListIndex;
    private int _quadBackListIndex;

    private float _pointTransparency;
    private float _lineTransparency;
    private float _triangleTransparency;
    private float _quadTransparency;
    private float _polylineTransparency;
    private float _pointSize;
    private float _lineWidth;
    private float _polylineWidth;

    private int[] _colors;

    /**
     * Returns the transform matrix.
     */
    public Matrix4f getTransform()
    {
        return _transform;
    }

    /**
     * Sets Whether initialized.
     */
    public void setInitialized(boolean initialized)
    {
        _initialized = initialized;
    }

    /**
     * Returns Whether initialized.
     */
    public boolean initialized()
    {
        return _initialized;
    }

    /**
     * Sets Whether to be refreshed.
     */
    public void setRefresh(boolean refresh)
    {
        _refresh = refresh;
    }

    /**
     * Tests Whether to be refreshed.
     */
    public boolean refresh()
    {
        return _refresh;
    }

    /**
     * Sets the point list index.
     */
    public void setPointListIndex(int pointListIndex)
    {
        _pointListIndex = pointListIndex;
    }

    /**
     * Returns the point list index.
     */
    public int getPointListIndex()
    {
        return _pointListIndex;
    }

    /**
     * Sets the line list index.
     */
    public void setLineListIndex(int lineListIndex)
    {
        _lineListIndex = lineListIndex;
    }

    /**
     * Returns the line list index.
     */
    public int getLineListIndex()
    {
        return _lineListIndex;
    }

    /**
     * Sets the triangle list index.
     */
    public void setTriangleListIndex(int triangleListIndex)
    {
        _triangleListIndex = triangleListIndex;
    }

    /**
     * Returns the triangle list index.
     */
    public int getTriangleListIndex()
    {
        return _triangleListIndex;
    }

    /**
     * Sets the quad list index.
     */
    public void setQuadListIndex(int quadListIndex)
    {
        _quadListIndex = quadListIndex;
    }

    /**
     * Returns the quad list index.
     */
    public int getQuadListIndex()
    {
        return _quadListIndex;
    }

    /**
     * Sets the triangle back list index.
     */
    public void setTriangleBackListIndex(int triangleBackListIndex)
    {
        _triangleBackListIndex = triangleBackListIndex;
    }

    /**
     * Returns the triangle back list index.
     */
    public int getTriangleBackListIndex()
    {
        return _triangleBackListIndex;
    }

    /**
     * Sets the quad back list index.
     */
    public void setQuadBackListIndex(int quadBackListIndex)
    {
        _quadBackListIndex = quadBackListIndex;
    }

    /**
     * Returns the quad back list index.
     */
    public int getQuadBackListIndex()
    {
        return _quadBackListIndex;
    }

    /**
     * Sets the polyline list index.
     */
    public void setPolylineListIndex(int polylineListIndex)
    {
        _polylineListIndex = polylineListIndex;
    }

    /**
     * Returns the polyline list index.
     */
    public int getPolylineListIndex()
    {
        return _polylineListIndex;
    }

    /**
     * Sets the transparency of point array.
     */
    public void setPointTransparency(float pointTransparency)
    {
        _pointTransparency = pointTransparency;
    }

    /**
     * Returns the transparency of point array.
     */
    public float getPointTransparency()
    {
        return _pointTransparency;
    }

    /**
     * Sets the transparency of line array.
     */
    public void setLineTransparency(float lineTransparency)
    {
        _lineTransparency = lineTransparency;
    }

    /**
     * Returns the transparency of line array.
     */
    public float getLineTransparency()
    {
        return _lineTransparency;
    }

    /**
     * Sets the transparency of triangle array.
     */
    public void setTriangleTransparency(float triangleTransparency)
    {
        _triangleTransparency = triangleTransparency;
    }

    /**
     * Returns the transparency of triangle array.
     */
    public float getTriangleTransparency()
    {
        return _triangleTransparency;
    }

    /**
     * Sets the transparency of quad array.
     */
    public void setQuadTransparency(float quadTransparency)
    {
        _quadTransparency = quadTransparency;
    }

    /**
     * Returns the transparency of quad array.
     */
    public float getQuadTransparency()
    {
        return _quadTransparency;
    }

    /**
     * Sets the transparency of polyline array.
     */
    public void setPolylineTransparency(float polylineTransparency)
    {
        _polylineTransparency = polylineTransparency;
    }

    /**
     * Returns the transparency of polyline array.
     */
    public float getPolylineTransparency()
    {
        return _polylineTransparency;
    }

    /**
     * Sets the size of point array.
     */
    public void setPointSize(float pointSize)
    {
        _pointSize = pointSize;
    }

    /**
     * Returns the size of point array.
     */
    public float getPointSize()
    {
        return _pointSize;
    }

    /**
     * Sets the line width of line array.
     */
    public void setLineWidth(float lineWidth)
    {
        _lineWidth = lineWidth;
    }

    /**
     * Returns the line width of line array.
     */
    public float getLineWidth()
    {
        return _lineWidth;
    }

    /**
     * Sets the line width of polyline array.
     */
    public void setPolylineWidth(float polylineWidth)
    {
        _polylineWidth = polylineWidth;
    }

    /**
     * Returns the line width of polyline array.
     */
    public float getPolylineWidth()
    {
        return _polylineWidth;
    }

    /**
     * Sets the current color of vertices.
     */
    public void setColors(int[] colors)
    {
        _colors = colors;
    }

    /**
     * Returns the current color of vertices.
     */
    public int[] getColors()
    {
        return _colors;
    }

    /**
     * Constructor.
     */
    public PolygonImage()
    {
        _transform = Matrix4f.identity();
        _refresh = true;
    }
}
