/*
 * Modified at March 2014.
 * RIKEN, Japan
 */

/*
* Binary and Source Code License Agreement for jV Version 4.3.1
* Copyright (c) 2003-2013, Protein Data Bank Japan
* All rights reserved.
* 
* The software, jV, and the associated documentation files (the 
* "Software") were developed by Drs. Kengo Kinoshita and Haruki Nakamura 
* in Protein Data Bank Japan at Institute for Protein Research, Osaka 
* University (the "Contributors"), which is supported by grant-in-aid 
* from National Bioscience Database Center, Japan Science and Technology
* Agancy (JST-NBDC) and Osaka University.
* 
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions 
* are met:
* 
* *  Redistributions of the source code for the Software must retain the
*    above copyright notice, this list of conditions and the following
*    disclaimer.
* 
* *  Redistributions in the binary form for the Software must reproduce
*    the above copyright notice, this list of conditions and the following
*    disclaimer in the documentation and/or other materials provided with
*    the distribution.
* 
* *  Neither the name of the Institute for Protein Research, Osaka University
*    nor the names of the Contributors may be used to endorse or promote
*    products derived from this software without specific prior written
*    permission.
* 
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
*    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
*    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
*    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
*    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
*    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
*    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
*    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
*    ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
*    POSSIBILITY OF SUCH DAMAGE.
*/
package org.pdbj.viewer.images;

/**
 * Image of residues.
 */
public abstract class ResidueImage extends ImageComponent
{
    public static final int MODEL_RIBBON  = 1;
    public static final int MODEL_CARTOON = 2;
    public static final int MODEL_TRACE   = 3;
    public static final int MODEL_CARTOON_TUBE = 4;

    private int _backColorIndex;

    /**
     * Sets the width of the image.
     */
    public abstract void setWidth(float width);

    /**
     * Returns the width of the image.
     */
    public abstract float getWidth();

    /**
     * Sets the list index.
     */
    public abstract void setListIndex(int listIndex);

    /**
     * Returns the list index.
     */
    public abstract int getListIndex();

    /**
     * Sets the back list index.
     */
    public abstract void setBackListIndex(int backListIndex);

    /**
     * Returns the back list index.
     */
    public abstract int getBackListIndex();

    /**
     * Sets the back color index.
     */
    public void setBackColorIndex(int backColorIndex)
    {
        _backColorIndex = backColorIndex;
    }

    /**
     * Returns the back color index.
     */
    public int getBackColorIndex()
    {
        return _backColorIndex;
    }

    /**
     * Default constructor.
     */
    public ResidueImage()
    {
        _backColorIndex = -1;
    }
}

